/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ModuleBuilderSource;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.def.ContributionDef3;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.DelegatingInjectionResources;
import org.apache.tapestry5.ioc.internal.util.InjectionResources;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.apache.tapestry5.ioc.internal.util.WrongConfigurationTypeGuard;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionDefImpl
implements ContributionDef3 {
    private final String serviceId;
    private final Method contributorMethod;
    private final boolean optional;
    private final PlasticProxyFactory proxyFactory;
    private final Set<Class> markers;
    private final Class serviceInterface;
    private static final Class[] CONFIGURATION_TYPES = new Class[]{Configuration.class, MappedConfiguration.class, OrderedConfiguration.class};

    public ContributionDefImpl(String serviceId, Method contributorMethod, boolean optional, PlasticProxyFactory proxyFactory, Class serviceInterface, Set<Class> markers) {
        this.serviceId = serviceId;
        this.contributorMethod = contributorMethod;
        this.optional = optional;
        this.proxyFactory = proxyFactory;
        this.serviceInterface = serviceInterface;
        this.markers = markers;
    }

    public String toString() {
        return InternalUtils.asString(this.contributorMethod, this.proxyFactory);
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, Configuration configuration) {
        this.invokeMethod(moduleSource, resources, Configuration.class, configuration);
    }

    @Override
    public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, OrderedConfiguration configuration) {
        this.invokeMethod(moduleSource, resources, OrderedConfiguration.class, configuration);
    }

    @Override
    public void contribute(ModuleBuilderSource moduleSource, ServiceResources resources, MappedConfiguration configuration) {
        this.invokeMethod(moduleSource, resources, MappedConfiguration.class, configuration);
    }

    private <T> void invokeMethod(ModuleBuilderSource source, ServiceResources resources, Class<T> parameterType, T parameterValue) {
        Map<Class, Object> resourceMap = CollectionFactory.newMap();
        resourceMap.put(parameterType, parameterValue);
        resourceMap.put(ObjectLocator.class, resources);
        resourceMap.put(Logger.class, resources.getLogger());
        InjectionResources injectionResources = new MapInjectionResources(resourceMap);
        for (Class t : CONFIGURATION_TYPES) {
            if (parameterType == t) continue;
            injectionResources = new DelegatingInjectionResources(new WrongConfigurationTypeGuard(resources.getServiceId(), t, parameterType), injectionResources);
        }
        Throwable fail = null;
        Object moduleInstance = InternalUtils.isStatic(this.contributorMethod) ? null : source.getModuleBuilder();
        try {
            ObjectCreator[] parameters = InternalUtils.calculateParametersForMethod(this.contributorMethod, resources, injectionResources, resources.getTracker());
            this.contributorMethod.invoke(moduleInstance, InternalUtils.realizeObjects(parameters));
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        if (fail != null) {
            throw new RuntimeException(IOCMessages.contributionMethodError(this.contributorMethod, fail), fail);
        }
    }

    @Override
    public Set<Class> getMarkers() {
        return this.markers;
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }
}

