/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.Collection;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.AbstractConfigurationImpl;
import org.apache.tapestry5.ioc.internal.IOCMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingConfigurationWrapper<T>
extends AbstractConfigurationImpl<T>
implements Configuration<T> {
    private final String serviceId;
    private final Class<T> expectedType;
    private final Collection<T> collection;

    public ValidatingConfigurationWrapper(Class<T> expectedType, ObjectLocator locator, Collection<T> collection, String serviceId) {
        super(expectedType, locator);
        this.collection = collection;
        this.serviceId = serviceId;
        this.expectedType = expectedType;
    }

    @Override
    public void add(T object) {
        if (object == null) {
            throw new NullPointerException(IOCMessages.contributionWasNull(this.serviceId));
        }
        if (!this.expectedType.isInstance(object)) {
            throw new IllegalArgumentException(IOCMessages.contributionWrongValueType(this.serviceId, object.getClass(), this.expectedType));
        }
        this.collection.add(object);
    }

    @Override
    public void addInstance(Class<? extends T> clazz) {
        this.add(this.instantiate(clazz));
    }
}

