/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.Loader;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.Translator;
import javassist.expr.ConstructorCall;
import javassist.expr.ExprEditor;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ReloadAware;
import org.apache.tapestry5.ioc.internal.services.ClassFactoryClassPool;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.services.UpdateListener;
import org.slf4j.Logger;

public abstract class AbstractReloadableObjectCreator
implements ObjectCreator,
UpdateListener,
Translator {
    private final ClassLoader baseClassLoader;
    private final String implementationClassName;
    private final String classFilePath;
    private final Logger logger;
    private final OperationTracker tracker;
    private final URLChangeTracker changeTracker = new URLChangeTracker();
    private final Set<String> classesToLoad = CollectionFactory.newSet();
    private Object instance;
    private boolean firstTime = true;

    protected AbstractReloadableObjectCreator(ClassLoader baseClassLoader, String implementationClassName, Logger logger, OperationTracker tracker) {
        this.baseClassLoader = baseClassLoader;
        this.implementationClassName = implementationClassName;
        this.logger = logger;
        this.tracker = tracker;
        this.classFilePath = ClassFabUtils.getPathForClassNamed(implementationClassName);
    }

    public synchronized void checkForUpdates() {
        if (this.instance == null) {
            return;
        }
        if (!this.changeTracker.containsChanges()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Implementation class %s has changed and will be reloaded on next use.", this.implementationClassName));
        }
        this.changeTracker.clear();
        boolean reloadNow = this.informInstanceOfReload();
        this.instance = reloadNow ? this.createInstance() : null;
    }

    private boolean informInstanceOfReload() {
        if (this.instance instanceof ReloadAware) {
            ReloadAware ra = (ReloadAware)this.instance;
            return ra.shutdownImplementationForReload();
        }
        return false;
    }

    public synchronized Object createObject() {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
        return this.instance;
    }

    private Object createInstance() {
        return this.tracker.invoke(String.format("Reloading class %s.", this.implementationClassName), new Invokable<Object>(){

            @Override
            public Object invoke() {
                Class reloadedClass = AbstractReloadableObjectCreator.this.reloadImplementationClass();
                return AbstractReloadableObjectCreator.this.createInstance(reloadedClass);
            }
        });
    }

    protected abstract Object createInstance(Class var1);

    private Class reloadImplementationClass() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("%s class %s.", this.firstTime ? "Loading" : "Reloading", this.implementationClassName));
        }
        ClassFactoryClassPool pool = new ClassFactoryClassPool(this.baseClassLoader);
        URLClassLoader threadDeadlockBuffer = new URLClassLoader(new URL[0], this.baseClassLoader);
        InternalLoader loader = new InternalLoader(threadDeadlockBuffer, pool);
        LoaderClassPath path = new LoaderClassPath((ClassLoader)((Object)loader));
        pool.appendClassPath((ClassPath)path);
        this.classesToLoad.clear();
        this.add(this.implementationClassName);
        try {
            loader.addTranslator(pool, this);
            Class result = loader.loadClass(this.implementationClassName);
            this.firstTime = false;
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Unable to %s class %s: %s", this.firstTime ? "load" : "reload", this.implementationClassName, InternalUtils.toMessage(ex)), ex);
        }
    }

    private boolean shouldLoadClassNamed(String name) {
        return this.classesToLoad.contains(name);
    }

    private void add(String className) {
        if (this.classesToLoad.contains(className)) {
            return;
        }
        this.logger.debug(String.format("Marking class %s to be (re-)loaded", className));
        this.classesToLoad.add(className);
    }

    public void onLoad(ClassPool pool, String className) throws NotFoundException, CannotCompileException {
        this.logger.debug(String.format("BEGIN Analyzing %s", className));
        this.analyze(pool, className);
        this.trackClassFileChanges(className);
        this.logger.debug(String.format("  END Analyzing %s", className));
    }

    private void analyze(ClassPool pool, String className) throws NotFoundException, CannotCompileException {
        CtClass[] nestedClasses;
        CtClass ctClass = pool.get(className);
        for (CtClass nc : nestedClasses = ctClass.getNestedClasses()) {
            this.add(nc.getName());
        }
        ctClass.instrument(new ExprEditor(){

            public void edit(ConstructorCall c) throws CannotCompileException {
                if (c.getMethodName().equals("this")) {
                    return;
                }
                String cn = c.getClassName();
                String classFilePath = ClassFabUtils.getPathForClassNamed(cn);
                URL url = AbstractReloadableObjectCreator.this.baseClassLoader.getResource(classFilePath);
                if (url != null && url.getProtocol().equals("file")) {
                    AbstractReloadableObjectCreator.this.add(cn);
                }
            }
        });
    }

    private void trackClassFileChanges(String className) {
        if (this.isInnerClassName(className)) {
            return;
        }
        String path = ClassFabUtils.getPathForClassNamed(className);
        URL url = this.baseClassLoader.getResource(path);
        if (url != null && url.getProtocol().equals("file")) {
            this.changeTracker.add(url);
        }
    }

    private boolean isInnerClassName(String className) {
        return className.indexOf(36) >= 0;
    }

    public void start(ClassPool pool) throws NotFoundException, CannotCompileException {
    }

    private class InternalLoader
    extends Loader {
        public InternalLoader(ClassLoader parent, ClassPool pool) {
            super(parent, pool);
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            if (AbstractReloadableObjectCreator.this.shouldLoadClassNamed(name)) {
                return super.findClass(name);
            }
            return null;
        }
    }
}

