/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.List;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryStartup
implements Runnable {
    private final Logger logger;
    private final List<Runnable> configuration;
    private final OneShotLock lock = new OneShotLock();

    public RegistryStartup(Logger logger, List<Runnable> configuration) {
        this.logger = logger;
        this.configuration = configuration;
    }

    @Override
    public void run() {
        this.lock.lock();
        for (Runnable r : this.configuration) {
            try {
                r.run();
            }
            catch (RuntimeException ex) {
                this.logger.error(ServiceMessages.startupFailure(ex));
            }
        }
        this.configuration.clear();
    }
}

