/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.util.UtilMessages;

public class TimePeriod {
    private static final Map<String, Long> UNITS = CollectionFactory.newCaseInsensitiveMap();
    private static final long MILLISECOND = 1000L;
    private static final Pattern PATTERN;
    private final long _milliseconds;

    public TimePeriod(String input) {
        this._milliseconds = TimePeriod.parseMilliseconds(input);
    }

    public long milliseconds() {
        return this._milliseconds;
    }

    public long seconds() {
        return this._milliseconds / 1000L;
    }

    static long parseMilliseconds(String input) {
        long milliseconds = 0L;
        Matcher matcher = PATTERN.matcher(input);
        matcher.useAnchoringBounds(true);
        int lastMatchEnd = -1;
        while (matcher.find()) {
            int start = matcher.start();
            if (lastMatchEnd + 1 < start) {
                String invalid = input.substring(lastMatchEnd + 1, start);
                throw new RuntimeException(UtilMessages.invalidTimePeriodInput(invalid, input));
            }
            lastMatchEnd = matcher.end();
            long count = Long.parseLong(matcher.group(1));
            String units = matcher.group(2);
            if (units.length() == 0) {
                milliseconds += count;
                continue;
            }
            Long unitValue = UNITS.get(units);
            if (unitValue == null) {
                throw new RuntimeException(UtilMessages.invalidTimePeriodUnit(units, input, UNITS.keySet()));
            }
            milliseconds += count * unitValue;
        }
        if (lastMatchEnd + 1 < input.length()) {
            String invalid = input.substring(lastMatchEnd + 1);
            throw new RuntimeException(UtilMessages.invalidTimePeriodInput(invalid, input));
        }
        return milliseconds;
    }

    public String toString() {
        return String.format("TimePeriod[%d ms]", this._milliseconds);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof TimePeriod) {
            TimePeriod tp = (TimePeriod)obj;
            return this._milliseconds == tp._milliseconds;
        }
        return false;
    }

    static {
        UNITS.put("ms", 1L);
        UNITS.put("s", 1000L);
        UNITS.put("m", 60000L);
        UNITS.put("h", 3600000L);
        UNITS.put("d", 86400000L);
        PATTERN = Pattern.compile("\\s*(\\d+)\\s*([a-z]*)", 2);
    }
}

