/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.services.ClassFab;
import org.apache.tapestry.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassFabUtils {
    private static long _uid = System.currentTimeMillis();
    private static final Map<String, PrimitiveInfo> PRIMITIVE_INFO = CollectionFactory.newMap();

    private ClassFabUtils() {
    }

    public static synchronized String generateClassName(String baseName) {
        return "$" + baseName + "_" + Long.toHexString(_uid++);
    }

    public static String generateClassName(Class interfaceClass) {
        return ClassFabUtils.generateClassName(interfaceClass.getSimpleName());
    }

    public static String toJavaClassName(Class inputClass) {
        if (inputClass.isArray()) {
            return ClassFabUtils.toJavaClassName(inputClass.getComponentType()) + "[]";
        }
        return inputClass.getName();
    }

    public static boolean isToString(Method method) {
        if (!method.getName().equals("toString")) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        return method.getReturnType().equals(String.class);
    }

    private static void add(String primitiveType, String typeCode, Class wrapperType, String unwrapMethod) {
        PRIMITIVE_INFO.put(primitiveType, new PrimitiveInfo(typeCode, wrapperType, unwrapMethod));
    }

    public static String toJVMBinaryName(String type) {
        if (!type.endsWith("[]")) {
            return type;
        }
        StringBuilder buffer = new StringBuilder();
        while (type.endsWith("[]")) {
            buffer.append("[");
            type = type.substring(0, type.length() - 2);
        }
        PrimitiveInfo pi = PRIMITIVE_INFO.get(type);
        if (pi != null) {
            buffer.append(pi.getTypeCode());
        } else {
            buffer.append("L");
            buffer.append(type);
            buffer.append(";");
        }
        return buffer.toString();
    }

    public static String getUnwrapMethodName(String primitiveTypeName) {
        return PRIMITIVE_INFO.get(primitiveTypeName).getUnwrapMethod();
    }

    public static String getWrapperTypeName(String primitiveType) {
        return PRIMITIVE_INFO.get(primitiveType).getWrapperType().getName();
    }

    public static Class getWrapperType(Class primitiveType) {
        if (primitiveType.isPrimitive()) {
            return PRIMITIVE_INFO.get(primitiveType.getName()).getWrapperType();
        }
        return primitiveType;
    }

    public static String getTypeCode(Class type) {
        if (type.equals(Void.TYPE)) {
            return "V";
        }
        if (type.isPrimitive()) {
            return PRIMITIVE_INFO.get(type.getName()).getTypeCode();
        }
        if (type.isArray()) {
            return "[" + ClassFabUtils.getTypeCode(type.getComponentType());
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    public static <T> T createObjectCreatorProxy(ClassFab classFab, Class<T> serviceInterface, ObjectCreator creator, String description) {
        classFab.addField("_creator", 18, ObjectCreator.class);
        classFab.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        String body = String.format("return (%s) _creator.createObject();", serviceInterface.getName());
        MethodSignature sig = new MethodSignature(serviceInterface, "_delegate", null, null);
        classFab.addMethod(2, sig, body);
        classFab.proxyMethodsToDelegate(serviceInterface, "_delegate()", description);
        Class proxyClass = classFab.createClass();
        try {
            Object proxy = proxyClass.getConstructors()[0].newInstance(creator);
            return serviceInterface.cast(proxy);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    static {
        ClassFabUtils.add("boolean", "Z", Boolean.class, "booleanValue");
        ClassFabUtils.add("short", "S", Short.class, "shortValue");
        ClassFabUtils.add("int", "I", Integer.class, "intValue");
        ClassFabUtils.add("long", "J", Long.class, "longValue");
        ClassFabUtils.add("float", "F", Float.class, "floatValue");
        ClassFabUtils.add("double", "D", Double.class, "doubleValue");
        ClassFabUtils.add("char", "C", Character.class, "charValue");
        ClassFabUtils.add("byte", "B", Byte.class, "byteValue");
    }

    private static class PrimitiveInfo {
        private final String _typeCode;
        private final Class _wrapperType;
        private final String _unwrapMethod;

        public PrimitiveInfo(String typeCode, Class wrapperType, String unwrapMethod) {
            this._typeCode = typeCode;
            this._wrapperType = wrapperType;
            this._unwrapMethod = unwrapMethod;
        }

        public String getTypeCode() {
            return this._typeCode;
        }

        public String getUnwrapMethod() {
            return this._unwrapMethod;
        }

        public Class getWrapperType() {
            return this._wrapperType;
        }
    }
}

