/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.List;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.apache.tapestry.ioc.services.RegistryShutdownHub;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.slf4j.Logger;

public class RegistryShutdownHubImpl
implements RegistryShutdownHub {
    private final OneShotLock _lock = new OneShotLock();
    private final Logger _logger;
    private final List<RegistryShutdownListener> _listeners = CollectionFactory.newThreadSafeList();

    public RegistryShutdownHubImpl(Logger logger) {
        this._logger = logger;
    }

    public void addRegistryShutdownListener(RegistryShutdownListener listener) {
        this._lock.check();
        this._listeners.add(listener);
    }

    public void fireRegistryDidShutdown() {
        this._lock.lock();
        for (RegistryShutdownListener l : this._listeners) {
            try {
                l.registryDidShutdown();
            }
            catch (Exception ex) {
                this._logger.error(ServiceMessages.shutdownListenerError(l, ex), (Throwable)ex);
            }
        }
        this._listeners.clear();
    }
}

