/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.tapestry5.internal.plastic.AbstractAnnotationBuilder;
import org.apache.tapestry5.internal.plastic.PlasticClassPool;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;

public class AnnotationBuilder
extends AbstractAnnotationBuilder {
    private final Class annotationType;
    final Map<String, Object> attributes = PlasticInternalUtils.newMap();

    public AnnotationBuilder(Class annotationType, PlasticClassPool pool) {
        super(pool);
        this.annotationType = annotationType;
        this.attributes.put("annotationType", annotationType);
        for (Method m : annotationType.getMethods()) {
            Object defaultValue = m.getDefaultValue();
            if (defaultValue == null) continue;
            this.attributes.put(m.getName(), defaultValue);
        }
        if (!this.attributes.containsKey("toString")) {
            this.attributes.put("toString", "@" + annotationType.getName());
        }
    }

    protected void store(String name, Object value) {
        this.attributes.put(name, value);
    }

    protected Class elementTypeForArrayAttribute(String name) {
        try {
            return this.annotationType.getMethod(name, new Class[0]).getReturnType().getComponentType();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to determine element type for attribute '%s' of annotation %s: %s", name, this.annotationType.getName(), PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    public Object createAnnotation() {
        AnnotationValueHandler handler = new AnnotationValueHandler(this.annotationType, this.attributes);
        try {
            return Proxy.newProxyInstance(this.pool.loader, new Class[]{this.annotationType}, (InvocationHandler)handler);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to create instance of annotation type %s: %s", this.annotationType.getName(), PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AnnotationValueHandler
    implements InvocationHandler {
        private final Class annotationType;
        private final Map<String, Object> attributes;

        public AnnotationValueHandler(Class annotationType, Map<String, Object> attributes) {
            this.annotationType = annotationType;
            this.attributes = attributes;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String attributeName;
            if (args == null && this.attributes.containsKey(attributeName = method.getName())) {
                return this.attributes.get(attributeName);
            }
            throw new RuntimeException(String.format("Annotation proxy for class %s does not handle method %s.", this.annotationType.getName(), method));
        }
    }
}

