/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class SQLRewriteContext {
    private final ShardingSphereDatabase database;
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final ParameterBuilder parameterBuilder;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();
    private final ConnectionContext connectionContext;

    public SQLRewriteContext(ShardingSphereDatabase database, SQLStatementContext sqlStatementContext, String sql, List<Object> params, ConnectionContext connectionContext, HintValueContext hintValueContext) {
        this.database = database;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.connectionContext = connectionContext;
        if (!hintValueContext.isSkipSQLRewrite()) {
            this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder(sqlStatementContext).getSQLTokenGenerators());
        }
        this.parameterBuilder = this.containsInsertValues(sqlStatementContext) ? new GroupedParameterBuilder(((InsertStatementContext)sqlStatementContext).getGroupedParameters(), ((InsertStatementContext)sqlStatementContext).getOnDuplicateKeyUpdateParameters()) : new StandardParameterBuilder(params);
    }

    private boolean containsInsertValues(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof InsertStatementContext)) {
            return false;
        }
        return null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.database.getName(), this.database.getSchemas(), this.sqlStatementContext, this.parameters, this.connectionContext));
    }

    @Generated
    public ShardingSphereDatabase getDatabase() {
        return this.database;
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Generated
    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

