/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource.node;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.core.exception.UnrecognizedDatabaseURLException;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;

public final class StorageNodeAggregator {
    public static Map<StorageNode, DataSource> aggregateDataSources(Map<String, DataSource> dataSourceMap) {
        return dataSourceMap.entrySet().stream().collect(Collectors.toMap(entry -> new StorageNode((String)entry.getKey()), Map.Entry::getValue, (oldValue, currentValue) -> currentValue, () -> new LinkedHashMap(dataSourceMap.size(), 1.0f)));
    }

    public static Map<StorageNode, DataSourcePoolProperties> aggregateDataSourcePoolProperties(Map<String, DataSourcePoolProperties> storageUnitDataSourcePoolPropsMap) {
        LinkedHashMap<StorageNode, DataSourcePoolProperties> result = new LinkedHashMap<StorageNode, DataSourcePoolProperties>();
        for (Map.Entry<String, DataSourcePoolProperties> entry : storageUnitDataSourcePoolPropsMap.entrySet()) {
            Map standardProps = entry.getValue().getConnectionPropertySynonyms().getStandardProperties();
            String url = standardProps.get("url").toString();
            boolean isInstanceConnectionAvailable = new DatabaseTypeRegistry(DatabaseTypeFactory.get((String)url)).getDialectDatabaseMetaData().isInstanceConnectionAvailable();
            StorageNode storageNode = StorageNodeAggregator.getStorageNode(entry.getKey(), url, standardProps.get("username").toString(), isInstanceConnectionAvailable);
            result.putIfAbsent(storageNode, entry.getValue());
        }
        return result;
    }

    private static StorageNode getStorageNode(String dataSourceName, String url, String username, boolean isInstanceConnectionAvailable) {
        try {
            JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
            return isInstanceConnectionAvailable ? new StorageNode(jdbcUrl.getHostname(), jdbcUrl.getPort(), username) : new StorageNode(dataSourceName);
        }
        catch (UnrecognizedDatabaseURLException ex) {
            return new StorageNode(dataSourceName);
        }
    }

    @Generated
    private StorageNodeAggregator() {
    }
}

