/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.segment.select.projection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ProjectionsContext {
    private static final String LAST_INSERT_ID_FUNCTION_EXPRESSION = "LAST_INSERT_ID()";
    private final int startIndex;
    private final int stopIndex;
    private final boolean distinctRow;
    private final Collection<Projection> projections;
    private final Collection<AggregationDistinctProjection> aggregationDistinctProjections;
    private final List<Projection> expandProjections;
    private final boolean containsLastInsertIdProjection;

    public ProjectionsContext(int startIndex, int stopIndex, boolean distinctRow, Collection<Projection> projections) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.distinctRow = distinctRow;
        this.projections = projections;
        this.aggregationDistinctProjections = this.createAggregationDistinctProjections();
        this.expandProjections = this.createExpandProjections();
        this.containsLastInsertIdProjection = this.isContainsLastInsertIdProjection(projections);
    }

    private Collection<AggregationDistinctProjection> createAggregationDistinctProjections() {
        LinkedList<AggregationDistinctProjection> result = new LinkedList<AggregationDistinctProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationDistinctProjection)) continue;
            result.add((AggregationDistinctProjection)each);
        }
        return result;
    }

    private List<Projection> createExpandProjections() {
        ArrayList<Projection> result = new ArrayList<Projection>();
        for (Projection each : this.projections) {
            if (each instanceof ShorthandProjection) {
                result.addAll(((ShorthandProjection)each).getActualColumns());
                continue;
            }
            if (each instanceof DerivedProjection) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isUnqualifiedShorthandProjection() {
        if (1 != this.projections.size()) {
            return false;
        }
        Projection projection = this.projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    public Optional<String> findAlias(String projectionName) {
        for (Projection each : this.projections) {
            Optional<Projection> projection;
            if (each instanceof ShorthandProjection && (projection = ((ShorthandProjection)each).getActualColumns().stream().filter(optional -> projectionName.equalsIgnoreCase(this.getOriginalColumnName((Projection)optional))).findFirst()).isPresent()) {
                return projection.map(Projection::getExpression);
            }
            if (!projectionName.equalsIgnoreCase(SQLUtils.getExactlyValue((String)each.getExpression()))) continue;
            return each.getAlias().map(IdentifierValue::getValue);
        }
        return Optional.empty();
    }

    private String getOriginalColumnName(Projection projection) {
        return projection instanceof ColumnProjection ? ((ColumnProjection)projection).getOriginalColumn().getValue() : projection.getExpression();
    }

    public Optional<Integer> findProjectionIndex(String projectionName) {
        int result = 1;
        for (Projection each : this.projections) {
            if (projectionName.equalsIgnoreCase(SQLUtils.getExactlyValue((String)each.getExpression()))) {
                return Optional.of(result);
            }
            ++result;
        }
        return Optional.empty();
    }

    public List<AggregationProjection> getAggregationProjections() {
        LinkedList<AggregationProjection> result = new LinkedList<AggregationProjection>();
        for (Projection each : this.projections) {
            if (!(each instanceof AggregationProjection)) continue;
            AggregationProjection aggregationProjection = (AggregationProjection)each;
            result.add(aggregationProjection);
            result.addAll(aggregationProjection.getDerivedAggregationProjections());
        }
        return result;
    }

    private boolean isContainsLastInsertIdProjection(Collection<Projection> projections) {
        for (Projection each : projections) {
            if (!LAST_INSERT_ID_FUNCTION_EXPRESSION.equalsIgnoreCase(SQLUtils.getExactlyExpression((String)each.getExpression()))) continue;
            return true;
        }
        return false;
    }

    public Optional<ColumnProjection> findColumnProjection(int columnIndex) {
        if (this.expandProjections.size() < columnIndex) {
            return Optional.empty();
        }
        Projection projection = this.expandProjections.get(columnIndex - 1);
        return projection instanceof ColumnProjection ? Optional.of((ColumnProjection)projection) : Optional.empty();
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public int getStopIndex() {
        return this.stopIndex;
    }

    @Generated
    public boolean isDistinctRow() {
        return this.distinctRow;
    }

    @Generated
    public Collection<Projection> getProjections() {
        return this.projections;
    }

    @Generated
    public Collection<AggregationDistinctProjection> getAggregationDistinctProjections() {
        return this.aggregationDistinctProjections;
    }

    @Generated
    public List<Projection> getExpandProjections() {
        return this.expandProjections;
    }

    @Generated
    public boolean isContainsLastInsertIdProjection() {
        return this.containsLastInsertIdProjection;
    }

    @Generated
    public String toString() {
        return "ProjectionsContext(startIndex=" + this.getStartIndex() + ", stopIndex=" + this.getStopIndex() + ", distinctRow=" + this.isDistinctRow() + ", projections=" + this.getProjections() + ", aggregationDistinctProjections=" + this.getAggregationDistinctProjections() + ", expandProjections=" + this.getExpandProjections() + ", containsLastInsertIdProjection=" + this.isContainsLastInsertIdProjection() + ")";
    }
}

