/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.sl.usermodel.MasterSheet;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.Resources;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.PackageHelper;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XSLFCommentAuthors;
import org.apache.poi.xslf.usermodel.XSLFFactory;
import org.apache.poi.xslf.usermodel.XSLFNotes;
import org.apache.poi.xslf.usermodel.XSLFNotesMaster;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTableStyles;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMasterIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesMasterIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPresentation;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMasterIdListEntry;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideSize;
import org.openxmlformats.schemas.presentationml.x2006.main.PresentationDocument;

public class XMLSlideShow
extends POIXMLDocument
implements SlideShow<XSLFShape, XSLFTextParagraph> {
    private static POILogger _logger = POILogFactory.getLogger(XMLSlideShow.class);
    private CTPresentation _presentation;
    private List<XSLFSlide> _slides;
    private List<XSLFSlideMaster> _masters;
    private List<XSLFPictureData> _pictures;
    private XSLFTableStyles _tableStyles;
    private XSLFNotesMaster _notesMaster;
    private XSLFCommentAuthors _commentAuthors;

    public XMLSlideShow() {
        this(XMLSlideShow.empty());
    }

    public XMLSlideShow(OPCPackage pkg) {
        super(pkg);
        try {
            if (this.getCorePart().getContentType().equals(XSLFRelation.THEME_MANAGER.getContentType())) {
                this.rebase(this.getPackage());
            }
            this.load(XSLFFactory.getInstance());
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    public XMLSlideShow(InputStream is) throws IOException {
        this(PackageHelper.open(is));
    }

    static final OPCPackage empty() {
        InputStream is = XMLSlideShow.class.getResourceAsStream("empty.pptx");
        if (is == null) {
            throw new POIXMLException("Missing resource 'empty.pptx'");
        }
        try {
            OPCPackage oPCPackage = OPCPackage.open(is);
            return oPCPackage;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                throw new POIXMLException(e);
            }
        }
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            PresentationDocument doc = PresentationDocument.Factory.parse((InputStream)this.getCorePart().getInputStream(), (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this._presentation = doc.getPresentation();
            HashMap<String, XSLFSlideMaster> masterMap = new HashMap<String, XSLFSlideMaster>();
            HashMap<String, XSLFSlide> shIdMap = new HashMap<String, XSLFSlide>();
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (p instanceof XSLFSlide) {
                    shIdMap.put(p.getPackageRelationship().getId(), (XSLFSlide)p);
                    continue;
                }
                if (p instanceof XSLFSlideMaster) {
                    masterMap.put(this.getRelationId(p), (XSLFSlideMaster)p);
                    continue;
                }
                if (p instanceof XSLFTableStyles) {
                    this._tableStyles = (XSLFTableStyles)p;
                    continue;
                }
                if (p instanceof XSLFNotesMaster) {
                    this._notesMaster = (XSLFNotesMaster)p;
                    continue;
                }
                if (!(p instanceof XSLFCommentAuthors)) continue;
                this._commentAuthors = (XSLFCommentAuthors)p;
            }
            this._masters = new ArrayList<XSLFSlideMaster>(masterMap.size());
            for (CTSlideMasterIdListEntry masterId : this._presentation.getSldMasterIdLst().getSldMasterIdList()) {
                XSLFSlideMaster master = (XSLFSlideMaster)masterMap.get(masterId.getId2());
                this._masters.add(master);
            }
            this._slides = new ArrayList<XSLFSlide>(shIdMap.size());
            if (this._presentation.isSetSldIdLst()) {
                for (CTSlideIdListEntry slId : this._presentation.getSldIdLst().getSldIdList()) {
                    XSLFSlide sh = (XSLFSlide)shIdMap.get(slId.getId2());
                    if (sh == null) {
                        _logger.log(5, new Object[]{"Slide with r:id " + slId.getId() + " was defined, but didn't exist in package, skipping"});
                        continue;
                    }
                    this._slides.add(sh);
                }
            }
        }
        catch (XmlException e) {
            throw new POIXMLException(e);
        }
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this._presentation.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        out.close();
    }

    @Override
    public List<PackagePart> getAllEmbedds() throws OpenXML4JException {
        return Collections.unmodifiableList(this.getPackage().getPartsByName(Pattern.compile("/ppt/embeddings/.*?")));
    }

    public List<XSLFPictureData> getPictureData() {
        if (this._pictures == null) {
            List<PackagePart> mediaParts = this.getPackage().getPartsByName(Pattern.compile("/ppt/media/.*?"));
            this._pictures = new ArrayList<XSLFPictureData>(mediaParts.size());
            for (PackagePart part : mediaParts) {
                XSLFPictureData pd = new XSLFPictureData(part, null);
                pd.setIndex(this._pictures.size());
                this._pictures.add(pd);
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public XSLFSlide createSlide(XSLFSlideLayout layout) {
        CTSlideIdList slideList;
        int slideNumber = 256;
        int cnt = 1;
        if (!this._presentation.isSetSldIdLst()) {
            slideList = this._presentation.addNewSldIdLst();
        } else {
            slideList = this._presentation.getSldIdLst();
            for (CTSlideIdListEntry slideId : slideList.getSldIdArray()) {
                slideNumber = (int)Math.max(slideId.getId() + 1L, (long)slideNumber);
                ++cnt;
            }
        }
        XSLFSlide slide = (XSLFSlide)this.createRelationship(XSLFRelation.SLIDE, XSLFFactory.getInstance(), cnt);
        CTSlideIdListEntry slideId = slideList.addNewSldId();
        slideId.setId((long)slideNumber);
        slideId.setId2(slide.getPackageRelationship().getId());
        layout.copyLayout(slide);
        slide.addRelation(layout.getPackageRelationship().getId(), layout);
        PackagePartName ppName = layout.getPackagePart().getPartName();
        slide.getPackagePart().addRelationship(ppName, TargetMode.INTERNAL, layout.getPackageRelationship().getRelationshipType());
        this._slides.add(slide);
        return slide;
    }

    public XSLFSlide createSlide() {
        XSLFSlideLayout layout = this._masters.get(0).getLayout(SlideLayout.BLANK);
        if (layout == null) {
            throw new IllegalArgumentException("Blank layout was not found");
        }
        return this.createSlide(layout);
    }

    public XSLFNotes getNotesSlide(XSLFSlide slide) {
        XSLFNotes notesSlide = slide.getNotes();
        if (notesSlide == null) {
            notesSlide = this.createNotesSlide(slide);
        }
        return notesSlide;
    }

    private XSLFNotes createNotesSlide(XSLFSlide slide) {
        if (this._notesMaster == null) {
            this.createNotesMaster();
        }
        Integer slideIndex = XSLFRelation.SLIDE.getFileNameIndex(slide);
        XSLFNotes notesSlide = (XSLFNotes)this.createRelationship(XSLFRelation.NOTES, XSLFFactory.getInstance(), slideIndex);
        notesSlide.addRelation(this._notesMaster.getPackageRelationship().getId(), this._notesMaster);
        PackagePartName notesMasterPackagePartName = this._notesMaster.getPackagePart().getPartName();
        notesSlide.getPackagePart().addRelationship(notesMasterPackagePartName, TargetMode.INTERNAL, this._notesMaster.getPackageRelationship().getRelationshipType());
        slide.addRelation(notesSlide.getPackageRelationship().getId(), notesSlide);
        PackagePartName notesSlidesPackagePartName = notesSlide.getPackagePart().getPartName();
        slide.getPackagePart().addRelationship(notesSlidesPackagePartName, TargetMode.INTERNAL, notesSlide.getPackageRelationship().getRelationshipType());
        notesSlide.addRelation(slide.getPackageRelationship().getId(), slide);
        PackagePartName slidesPackagePartName = slide.getPackagePart().getPartName();
        notesSlide.getPackagePart().addRelationship(slidesPackagePartName, TargetMode.INTERNAL, slide.getPackageRelationship().getRelationshipType());
        notesSlide.importContent(this._notesMaster);
        return notesSlide;
    }

    public void createNotesMaster() {
        this._notesMaster = (XSLFNotesMaster)this.createRelationship(XSLFRelation.NOTES_MASTER, XSLFFactory.getInstance(), 1);
        CTNotesMasterIdList notesMasterIdList = this._presentation.addNewNotesMasterIdLst();
        CTNotesMasterIdListEntry notesMasterId = notesMasterIdList.addNewNotesMasterId();
        notesMasterId.setId(this._notesMaster.getPackageRelationship().getId());
        Integer themeIndex = 1;
        ArrayList<Integer> themeIndexList = new ArrayList<Integer>();
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (!(p instanceof XSLFTheme)) continue;
            themeIndexList.add(XSLFRelation.THEME.getFileNameIndex(p));
        }
        if (!themeIndexList.isEmpty()) {
            Boolean found = false;
            Integer i = 1;
            while (i <= themeIndexList.size()) {
                if (!themeIndexList.contains(i)) {
                    found = true;
                    themeIndex = i;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            if (!found.booleanValue()) {
                themeIndex = themeIndexList.size() + 1;
            }
        }
        XSLFTheme theme = (XSLFTheme)this.createRelationship(XSLFRelation.THEME, XSLFFactory.getInstance(), themeIndex);
        theme.importTheme(this.getSlides().get(0).getTheme());
        this._notesMaster.addRelation(theme.getPackageRelationship().getId(), theme);
        PackagePartName themePackagePartName = theme.getPackagePart().getPartName();
        this._notesMaster.getPackagePart().addRelationship(themePackagePartName, TargetMode.INTERNAL, theme.getPackageRelationship().getRelationshipType());
    }

    public XSLFNotesMaster getNotesMaster() {
        return this._notesMaster;
    }

    public List<XSLFSlideMaster> getSlideMasters() {
        return this._masters;
    }

    public List<XSLFSlide> getSlides() {
        return this._slides;
    }

    public XSLFCommentAuthors getCommentAuthors() {
        return this._commentAuthors;
    }

    public void setSlideOrder(XSLFSlide slide, int newIndex) {
        int oldIndex = this._slides.indexOf(slide);
        if (oldIndex == -1) {
            throw new IllegalArgumentException("Slide not found");
        }
        if (oldIndex == newIndex) {
            return;
        }
        this._slides.add(newIndex, this._slides.remove(oldIndex));
        CTSlideIdList sldIdLst = this._presentation.getSldIdLst();
        CTSlideIdListEntry[] entries = sldIdLst.getSldIdArray();
        CTSlideIdListEntry oldEntry = entries[oldIndex];
        if (oldIndex < newIndex) {
            System.arraycopy(entries, oldIndex + 1, entries, oldIndex, newIndex - oldIndex);
        } else {
            System.arraycopy(entries, newIndex, entries, newIndex + 1, oldIndex - newIndex);
        }
        entries[newIndex] = oldEntry;
        sldIdLst.setSldIdArray(entries);
    }

    public XSLFSlide removeSlide(int index) {
        XSLFSlide slide = this._slides.remove(index);
        this.removeRelation(slide);
        this._presentation.getSldIdLst().removeSldId(index);
        return slide;
    }

    public Dimension getPageSize() {
        CTSlideSize sz = this._presentation.getSldSz();
        int cx = sz.getCx();
        int cy = sz.getCy();
        return new Dimension((int)Units.toPoints((long)cx), (int)Units.toPoints((long)cy));
    }

    public void setPageSize(Dimension pgSize) {
        CTSlideSize sz = CTSlideSize.Factory.newInstance();
        sz.setCx(Units.toEMU((double)pgSize.getWidth()));
        sz.setCy(Units.toEMU((double)pgSize.getHeight()));
        this._presentation.setSldSz(sz);
    }

    @Internal
    public CTPresentation getCTPresentation() {
        return this._presentation;
    }

    public XSLFPictureData addPicture(byte[] pictureData, PictureData.PictureType format) {
        XSLFPictureData img = this.findPictureData(pictureData);
        if (img != null) {
            return img;
        }
        int imageNumber = this._pictures.size();
        XSLFRelation relType = XSLFPictureData.getRelationForType(format);
        if (relType == null) {
            throw new IllegalArgumentException("Picture type " + format + " is not supported.");
        }
        img = (XSLFPictureData)this.createRelationship(relType, XSLFFactory.getInstance(), imageNumber + 1, true);
        img.setIndex(imageNumber);
        this._pictures.add(img);
        try {
            OutputStream out = img.getPackagePart().getOutputStream();
            out.write(pictureData);
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        return img;
    }

    XSLFPictureData findPictureData(byte[] pictureData) {
        long checksum = IOUtils.calculateChecksum((byte[])pictureData);
        byte[] cs = new byte[8];
        LittleEndian.putLong((byte[])cs, (int)0, (long)checksum);
        for (XSLFPictureData pic : this.getPictureData()) {
            if (!Arrays.equals(pic.getChecksum(), cs)) continue;
            return pic;
        }
        return null;
    }

    public XSLFSlideLayout findLayout(String name) {
        for (XSLFSlideMaster master : this.getSlideMasters()) {
            XSLFSlideLayout layout = master.getLayout(name);
            if (layout == null) continue;
            return layout;
        }
        return null;
    }

    public XSLFTableStyles getTableStyles() {
        return this._tableStyles;
    }

    CTTextParagraphProperties getDefaultParagraphStyle(int level) {
        XmlObject[] o = this._presentation.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' .//p:defaultTextStyle/a:lvl" + (level + 1) + "pPr");
        if (o.length == 1) {
            return (CTTextParagraphProperties)o[0];
        }
        return null;
    }

    public MasterSheet<XSLFShape, XSLFTextParagraph> createMasterSheet() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Resources getResources() {
        throw new UnsupportedOperationException();
    }
}

