/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.tokenize;

import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;
import opennlp.uima.tokenize.AbstractTokenizer;
import opennlp.uima.tokenize.TokenizerModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class Tokenizer
extends AbstractTokenizer {
    private TokenizerME tokenizer;
    private Feature probabilityFeature;

    public Tokenizer() {
        super("OpenNLP Tokenizer");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        TokenizerModel model;
        super.initialize(context);
        try {
            TokenizerModelResource modelResource = (TokenizerModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.tokenizer = new TokenizerME(model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.tokenType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
    }

    protected Span[] tokenize(CAS cas, AnnotationFS sentence) {
        return this.tokenizer.tokenizePos(sentence.getCoveredText());
    }

    protected void postProcessAnnotations(Span[] tokens, AnnotationFS[] tokenAnnotations) {
        if (this.probabilityFeature != null) {
            double[] tokenProbabilties = this.tokenizer.getTokenProbabilities();
            for (int i = 0; i < tokenAnnotations.length; ++i) {
                tokenAnnotations[i].setDoubleValue(this.probabilityFeature, tokenProbabilties[i]);
            }
        }
    }

    public void destroy() {
        this.tokenizer = null;
    }
}

