/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.EvaluationMonitor;

@Internal
public abstract class DetailedFMeasureListener<T>
implements EvaluationMonitor<T> {
    private int samples = 0;
    private final Stats generalStats = new Stats();
    private final Map<String, Stats> statsForOutcome = new HashMap<String, Stats>();
    private static final String PERCENT = "% 7.2f%%";
    private static final String FORMAT = "%12s: precision: % 7.2f%%;  recall: % 7.2f%%; F1: % 7.2f%%.";
    private static final String FORMAT_EXTRA = "%12s: precision: % 7.2f%%;  recall: % 7.2f%%; F1: % 7.2f%%. [target: %3d; tp: %3d; fp: %3d]";

    protected abstract Span[] asSpanArray(T var1);

    @Override
    public void correctlyClassified(T reference, T prediction) {
        Span[] spans;
        ++this.samples;
        for (Span span : spans = this.asSpanArray(reference)) {
            this.addTruePositive(span.getType());
        }
    }

    @Override
    public void misclassified(T reference, T prediction) {
        ++this.samples;
        Span[] references = this.asSpanArray(reference);
        Span[] predictions = this.asSpanArray(prediction);
        HashSet<Span> refSet = new HashSet<Span>(Arrays.asList(references));
        HashSet<Span> predSet = new HashSet<Span>(Arrays.asList(predictions));
        for (Span ref : refSet) {
            if (predSet.contains(ref)) {
                this.addTruePositive(ref.getType());
                continue;
            }
            this.addFalseNegative(ref.getType());
        }
        for (Span pred : predSet) {
            if (refSet.contains(pred)) continue;
            this.addFalsePositive(pred.getType());
        }
    }

    private void addTruePositive(String type) {
        Stats s = this.initStatsForOutcomeAndGet(type);
        s.incrementTruePositive();
        s.incrementTarget();
        this.generalStats.incrementTruePositive();
        this.generalStats.incrementTarget();
    }

    private void addFalsePositive(String type) {
        Stats s = this.initStatsForOutcomeAndGet(type);
        s.incrementFalsePositive();
        this.generalStats.incrementFalsePositive();
    }

    private void addFalseNegative(String type) {
        Stats s = this.initStatsForOutcomeAndGet(type);
        s.incrementTarget();
        this.generalStats.incrementTarget();
    }

    private Stats initStatsForOutcomeAndGet(String type) {
        if (!this.statsForOutcome.containsKey(type)) {
            this.statsForOutcome.put(type, new Stats());
        }
        return this.statsForOutcome.get(type);
    }

    public String createReport() {
        return this.createReport(Locale.getDefault());
    }

    public String createReport(Locale locale) {
        StringBuilder ret = new StringBuilder();
        int tp = this.generalStats.getTruePositives();
        int found = this.generalStats.getFalsePositives() + tp;
        ret.append("Evaluated ").append(this.samples).append(" samples with ").append(this.generalStats.getTarget()).append(" entities; found: ").append(found).append(" entities; correct: ").append(tp).append(".\n");
        ret.append(String.format(locale, FORMAT, "TOTAL", this.zeroOrPositive(this.generalStats.getPrecisionScore() * 100.0), this.zeroOrPositive(this.generalStats.getRecallScore() * 100.0), this.zeroOrPositive(this.generalStats.getFMeasure() * 100.0)));
        ret.append("\n");
        TreeSet<String> set = new TreeSet<String>(new F1Comparator());
        set.addAll(this.statsForOutcome.keySet());
        for (String type : set) {
            ret.append(String.format(locale, FORMAT_EXTRA, type, this.zeroOrPositive(this.statsForOutcome.get(type).getPrecisionScore() * 100.0), this.zeroOrPositive(this.statsForOutcome.get(type).getRecallScore() * 100.0), this.zeroOrPositive(this.statsForOutcome.get(type).getFMeasure() * 100.0), this.statsForOutcome.get(type).getTarget(), this.statsForOutcome.get(type).getTruePositives(), this.statsForOutcome.get(type).getFalsePositives()));
            ret.append("\n");
        }
        return ret.toString();
    }

    public String toString() {
        return this.createReport();
    }

    private double zeroOrPositive(double v) {
        if (v < 0.0) {
            return 0.0;
        }
        return v;
    }

    private static class Stats {
        private int falsePositiveCounter = 0;
        private int truePositiveCounter = 0;
        private int targetCounter = 0;

        private Stats() {
        }

        public void incrementFalsePositive() {
            ++this.falsePositiveCounter;
        }

        public void incrementTruePositive() {
            ++this.truePositiveCounter;
        }

        public void incrementTarget() {
            ++this.targetCounter;
        }

        public int getFalsePositives() {
            return this.falsePositiveCounter;
        }

        public int getTruePositives() {
            return this.truePositiveCounter;
        }

        public int getTarget() {
            return this.targetCounter;
        }

        public double getPrecisionScore() {
            int tp = this.getTruePositives();
            int selected = tp + this.getFalsePositives();
            return selected > 0 ? (double)tp / (double)selected : 0.0;
        }

        public double getRecallScore() {
            int target = this.getTarget();
            int tp = this.getTruePositives();
            return target > 0 ? (double)tp / (double)target : 0.0;
        }

        public double getFMeasure() {
            if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
                return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
            }
            return -1.0;
        }
    }

    private class F1Comparator
    implements Comparator<String> {
        private F1Comparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            double t1 = 0.0;
            double t2 = 0.0;
            if (DetailedFMeasureListener.this.statsForOutcome.containsKey(o1)) {
                t1 += DetailedFMeasureListener.this.statsForOutcome.get(o1).getFMeasure();
            }
            if (DetailedFMeasureListener.this.statsForOutcome.containsKey(o2)) {
                t2 += DetailedFMeasureListener.this.statsForOutcome.get(o2).getFMeasure();
            }
            if ((t1 = DetailedFMeasureListener.this.zeroOrPositive(t1)) + (t2 = DetailedFMeasureListener.this.zeroOrPositive(t2)) > 0.0) {
                if (t1 > t2) {
                    return -1;
                }
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

