/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.IOException;
import java.util.List;
import opennlp.tools.formats.masc.MascDocument;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class MascPOSSampleStream
extends FilterObjectStream<MascDocument, POSSample> {
    MascDocument buffer;

    public MascPOSSampleStream(ObjectStream<MascDocument> samples) throws IOException {
        super(samples);
        try {
            do {
                this.buffer = samples.read();
            } while (!this.buffer.hasPennTags());
        }
        catch (Exception e) {
            throw new IOException("None of the documents has POS tags" + e.getMessage());
        }
    }

    @Override
    public POSSample read() throws IOException {
        try {
            MascSentence sentence = this.buffer.read();
            while (sentence == null) {
                this.buffer = (MascDocument)this.samples.read();
                if (this.buffer == null) {
                    return null;
                }
                if (!this.buffer.hasPennTags()) continue;
                sentence = this.buffer.read();
            }
            List<String> tokens = sentence.getTokenStrings();
            List<String> POStags = sentence.getTags();
            return new POSSample(tokens, POStags);
        }
        catch (IOException e) {
            throw new IOException("Could not get a sample of POS tags from the data.");
        }
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
        this.buffer = (MascDocument)this.samples.read();
    }
}

