/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import opennlp.tools.formats.masc.MascNamedEntityParser;
import opennlp.tools.formats.masc.MascPennTagParser;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.formats.masc.MascSentenceParser;
import opennlp.tools.formats.masc.MascWord;
import opennlp.tools.formats.masc.MascWordParser;
import opennlp.tools.util.Span;
import opennlp.tools.util.XmlUtil;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MascDocument {
    private final List<MascSentence> sentences;
    private final String pathToFile;
    private Iterator<MascSentence> sentenceIterator;
    private boolean hasPennTags = false;
    private boolean hasNamedEntities = false;

    public MascDocument(String path, List<MascSentence> sentences) {
        this.pathToFile = path;
        this.sentences = sentences;
        this.sentenceIterator = sentences.iterator();
    }

    public static MascDocument parseDocument(String path, InputStream f_primary, InputStream f_seg, InputStream f_penn, InputStream f_s, InputStream f_ne) throws IOException {
        String text = MascDocument.readText(f_primary);
        List<MascWord> words = MascDocument.parseWords(f_seg);
        List<Span> sentenceSpans = MascDocument.parseSentences(f_s);
        List<MascSentence> sentences = MascDocument.combineAnnotations(text, sentenceSpans, words);
        MascDocument doc = new MascDocument(path, sentences);
        if (f_penn != null) {
            doc.addPennTags(MascDocument.parsePennTags(f_penn));
        }
        if (f_ne != null) {
            doc.addNamedEntityTags(MascDocument.parseNamedEntity(f_ne));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readText(InputStream stream) throws IOException {
        try {
            int read;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            StringBuilder contents = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                contents.append(buffer, 0, read);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<MascWord> parseWords(InputStream f_seg) throws IOException {
        try {
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascWordParser handler = new MascWordParser();
            try {
                saxParser.parse(f_seg, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the region annotation file");
            }
            List<MascWord> list = Collections.unmodifiableList(handler.getAnchors());
            return list;
        }
        finally {
            f_seg.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Span> parseSentences(InputStream f_s) throws IOException {
        try {
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascSentenceParser handler = new MascSentenceParser();
            try {
                saxParser.parse(f_s, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the sentence annotation file");
            }
            List<Span> anchors = handler.getAnchors();
            ArrayList<Span> filteredAnchors = new ArrayList<Span>();
            for (int i = 0; i < anchors.size() - 1; ++i) {
                if (anchors.get(i).getEnd() >= anchors.get(i + 1).getStart()) continue;
                filteredAnchors.add(anchors.get(i));
            }
            filteredAnchors.add(anchors.get(anchors.size() - 1));
            List<Span> list = Collections.unmodifiableList(filteredAnchors);
            return list;
        }
        finally {
            f_s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map> parsePennTags(InputStream f_penn) throws IOException {
        HashMap<String, Map> tagsAndBases = new HashMap<String, Map>();
        try {
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascPennTagParser handler = new MascPennTagParser();
            try {
                saxParser.parse(f_penn, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                throw new IOException("Could not parse the Penn tag annotation file");
            }
            tagsAndBases.put("tokenToTag", handler.getTags());
            tagsAndBases.put("tokenToBase", handler.getBases());
            tagsAndBases.put("tokenToQuarks", handler.getTokenToQuarks());
            HashMap<String, Map> hashMap = tagsAndBases;
            return hashMap;
        }
        finally {
            f_penn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map> parseNamedEntity(InputStream f_ne) throws IOException {
        try {
            SAXParser saxParser = XmlUtil.createSaxParser();
            MascNamedEntityParser handler = new MascNamedEntityParser();
            try {
                saxParser.parse(f_ne, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                System.out.println(e.getMessage());
                throw new IOException("Could not parse the named entity annotation file");
            }
            Map<Integer, String> entityIDtoEntityType = handler.getEntityIDtoEntityType();
            Map<Integer, List<Integer>> entityIDsToTokens = handler.getEntityIDsToTokens();
            HashMap<String, Map> results = new HashMap<String, Map>();
            results.put("entityIDtoEntityType", entityIDtoEntityType);
            results.put("entityIDsToTokens", entityIDsToTokens);
            HashMap<String, Map> hashMap = results;
            return hashMap;
        }
        finally {
            f_ne.close();
        }
    }

    private static List<MascSentence> combineAnnotations(String text, List<Span> sentenceSpans, List<MascWord> words) throws IOException {
        int wordIndex = 0;
        int wordCount = words.size();
        ArrayList<MascSentence> sentences = new ArrayList<MascSentence>();
        for (Span s : sentenceSpans) {
            if (s.getEnd() - s.getStart() <= 0) continue;
            ArrayList<MascWord> quarks = new ArrayList<MascWord>();
            int sentenceStart = s.getStart();
            int sentenceEnd = s.getEnd();
            MascWord nextWord = words.get(wordIndex);
            while (sentenceStart < nextWord.getEnd() && wordIndex > 0) {
                nextWord = words.get(--wordIndex);
            }
            boolean sentenceOver = false;
            while (!sentenceOver && wordIndex < wordCount) {
                nextWord = words.get(wordIndex);
                int nextWordStart = nextWord.getStart();
                int nextWordEnd = nextWord.getEnd();
                if (sentenceEnd > nextWordStart && sentenceStart < nextWordEnd) {
                    quarks.add(nextWord);
                    if (sentenceEnd == nextWordEnd) {
                        sentenceOver = true;
                    }
                    ++wordIndex;
                    continue;
                }
                if (sentenceEnd <= nextWordStart) {
                    sentenceOver = true;
                    continue;
                }
                ++wordIndex;
            }
            if (!sentenceOver && sentences.size() != sentenceSpans.size() - 1) {
                throw new IOException("Sentence ends and word ends do not match.First sentence not completed ends at character: " + sentenceEnd);
            }
            MascSentence sentence = new MascSentence(sentenceStart, sentenceEnd, text, quarks, words);
            sentences.add(sentence);
        }
        return Collections.unmodifiableList(sentences);
    }

    private void addNamedEntityTags(Map<String, Map> namedEntities) {
        try {
            Map entityIDtoEntityType = namedEntities.get("entityIDtoEntityType");
            Map entityIDsToTokens = namedEntities.get("entityIDsToTokens");
            for (MascSentence s : this.sentences) {
                boolean success = s.addNamedEntities(entityIDtoEntityType, entityIDsToTokens);
                if (success) continue;
                System.out.println("\tIssues occurred in the file: " + this.pathToFile);
            }
            this.hasNamedEntities = true;
        }
        catch (IOException e) {
            System.err.println("[ERROR] Failed connecting tokens and named entities.");
            System.err.println("\tThe error occurred in the file: " + this.pathToFile);
            System.err.println(e.getMessage());
            System.err.println(Arrays.toString(e.getStackTrace()));
        }
    }

    private void addPennTags(Map<String, Map> tagMaps) throws IOException {
        try {
            Map tokenToTag = tagMaps.get("tokenToTag");
            Map tokenToBase = tagMaps.get("tokenToBase");
            Map tokenToQuarks = tagMaps.get("tokenToQuarks");
            for (Map.Entry token : tokenToQuarks.entrySet()) {
                if (((int[])token.getValue()).length != 0) continue;
                System.err.println("[ERROR] Token without quarks: " + token.getKey());
            }
            HashMap<Integer, int[]> quarkToTokens = new HashMap<Integer, int[]>();
            for (Map.Entry tokenAndQuarks : tokenToQuarks.entrySet()) {
                int[] quarks;
                int token = (Integer)tokenAndQuarks.getKey();
                for (int quark : quarks = (int[])tokenAndQuarks.getValue()) {
                    if (quarkToTokens.containsKey(quark)) {
                        int[] tokens = (int[])quarkToTokens.get(quark);
                        int[] newTokens = new int[tokens.length + 1];
                        newTokens[0] = token;
                        System.arraycopy(tokens, 0, newTokens, 1, tokens.length);
                        System.out.println("[WARNING] One quark belongs to several tokens. f-seg ID: " + quark);
                        System.out.println("\tThe error occurred in file: " + this.pathToFile);
                        quarkToTokens.put(quark, newTokens);
                        continue;
                    }
                    quarkToTokens.put(quark, new int[]{token});
                }
            }
            for (MascSentence s : this.sentences) {
                boolean success = s.tokenizePenn(tokenToQuarks, quarkToTokens, tokenToBase, tokenToTag);
                if (success) continue;
                System.out.println("\tIssue occurred in file: " + this.pathToFile);
            }
            this.hasPennTags = true;
        }
        catch (Exception e) {
            throw new IOException("Could not attach POS tags to words. " + e.getMessage() + Arrays.toString(e.getStackTrace()));
        }
    }

    public boolean hasPennTags() {
        return this.hasPennTags;
    }

    public boolean hasNamedEntities() {
        return this.hasNamedEntities;
    }

    public MascSentence read() {
        MascSentence next = null;
        if (this.sentenceIterator.hasNext()) {
            next = this.sentenceIterator.next();
        }
        return next;
    }

    public void reset() {
        this.sentenceIterator = this.sentences.iterator();
    }
}

