/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredArchive
implements Archive {
    private final Archive archive;
    private final Filter filter;

    public FilteredArchive(Archive archive, Filter filter) {
        this.archive = archive;
        this.filter = filter;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.archive.getBytecode(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.archive.loadClass(className);
    }

    @Override
    public Iterator<String> iterator() {
        return new FilteredIterator(this.archive.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FilteredIterator
    implements Iterator<String> {
        private final Iterator<String> it;
        private String next;

        private FilteredIterator(Iterator<String> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.seek();
            return this.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String s = this.next;
            this.next = null;
            return s;
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        private void seek() {
            while (this.next == null && this.it.hasNext()) {
                this.next = this.it.next();
                if (FilteredArchive.this.filter.accept(this.next)) {
                    return;
                }
                this.next = null;
            }
        }
    }
}

