/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.log;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactoryAdapter;

public class Log4JLogFactory
extends LogFactoryAdapter {
    @Override
    protected Log newLogAdapter(String channel) {
        return new LogAdapter(LogManager.getLogger(channel));
    }

    public static class LogAdapter
    implements Log {
        private Logger _log;

        private LogAdapter(Logger wrapee) {
            this._log = wrapee;
        }

        public Logger getDelegate() {
            return this._log;
        }

        @Override
        public boolean isTraceEnabled() {
            return this._log.isEnabledFor(Level.DEBUG);
        }

        @Override
        public boolean isInfoEnabled() {
            return this._log.isEnabledFor(Level.INFO);
        }

        @Override
        public boolean isWarnEnabled() {
            return this._log.isEnabledFor(Level.WARN);
        }

        @Override
        public boolean isErrorEnabled() {
            return this._log.isEnabledFor(Level.ERROR);
        }

        @Override
        public boolean isFatalEnabled() {
            return this._log.isEnabledFor(Level.FATAL);
        }

        @Override
        public void trace(Object o) {
            this._log.debug(o);
        }

        @Override
        public void trace(Object o, Throwable t) {
            this._log.debug(o, t);
        }

        @Override
        public void info(Object o) {
            this._log.info(o);
        }

        @Override
        public void info(Object o, Throwable t) {
            this._log.info(o, t);
        }

        @Override
        public void warn(Object o) {
            this._log.warn(o);
        }

        @Override
        public void warn(Object o, Throwable t) {
            this._log.warn(o, t);
        }

        @Override
        public void error(Object o) {
            this._log.error(o);
        }

        @Override
        public void error(Object o, Throwable t) {
            this._log.error(o, t);
        }

        @Override
        public void fatal(Object o) {
            this._log.fatal(o);
        }

        @Override
        public void fatal(Object o, Throwable t) {
            this._log.fatal(o, t);
        }
    }
}

