/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.ScheduleExpression;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.timer.DefaultTimerThreadPoolAdapter;
import org.apache.openejb.core.timer.EjbTimeoutJob;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.timer.TimerStoreException;
import org.apache.openejb.core.timer.TimerType;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class EjbTimerServiceImpl
implements EjbTimerService {
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    public static final String QUARTZ_THREAD_POOL_ADAPTER = "openejb.org.quartz.threadPool.class";
    public static final String OPENEJB_TIMEOUT_JOB_NAME = "OPENEJB_TIMEOUT_JOB";
    public static final String OPENEJB_TIMEOUT_JOB_GROUP_NAME = "OPENEJB_TIMEOUT_GROUP";
    private final TransactionManager transactionManager;
    final BeanContext deployment;
    private final boolean transacted;
    private final int retryAttempts;
    private final TimerStore timerStore;
    private Scheduler scheduler;

    public EjbTimerServiceImpl(BeanContext deployment) {
        this(deployment, EjbTimerServiceImpl.getDefaultTransactionManager(), EjbTimerServiceImpl.getDefaultScheduler(), new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager()), 1);
    }

    public static TransactionManager getDefaultTransactionManager() {
        return SystemInstance.get().getComponent(TransactionManager.class);
    }

    public EjbTimerServiceImpl(BeanContext deployment, TransactionManager transactionManager, Scheduler scheduler, TimerStore timerStore, int retryAttempts) {
        this.deployment = deployment;
        this.transactionManager = transactionManager;
        this.scheduler = scheduler;
        this.timerStore = timerStore;
        TransactionType transactionType = deployment.getTransactionType(deployment.getEjbTimeout());
        this.transacted = transactionType == TransactionType.Required || transactionType == TransactionType.RequiresNew;
        this.retryAttempts = retryAttempts;
    }

    public static synchronized Scheduler getDefaultScheduler() {
        Scheduler scheduler = SystemInstance.get().getComponent(Scheduler.class);
        if (scheduler == null) {
            Properties properties = new Properties();
            properties.put("org.quartz.threadPool.class", SystemInstance.get().hasProperty(QUARTZ_THREAD_POOL_ADAPTER) ? SystemInstance.get().getProperty(QUARTZ_THREAD_POOL_ADAPTER) : DefaultTimerThreadPoolAdapter.class.getName());
            properties.put("org.quartz.scheduler.instanceName", "OpenEJB-TimerService-Scheduler");
            try {
                scheduler = new StdSchedulerFactory(properties).getScheduler();
                scheduler.start();
                scheduler.addJob(new JobDetail(OPENEJB_TIMEOUT_JOB_NAME, OPENEJB_TIMEOUT_JOB_GROUP_NAME, EjbTimeoutJob.class, false, true, false), true);
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Fail to initialize the default scheduler", e);
            }
            SystemInstance.get().setComponent(Scheduler.class, scheduler);
        }
        return scheduler;
    }

    public static void shutdown() {
        Scheduler scheduler = SystemInstance.get().getComponent(Scheduler.class);
        if (scheduler != null) {
            try {
                scheduler.shutdown();
            }
            catch (SchedulerException e) {
                throw new RuntimeException("Unable to shutdown scheduler", e);
            }
        }
    }

    @Override
    public void start() throws TimerStoreException {
        Collection<TimerData> timerDatas = this.timerStore.loadTimers(this, (String)this.deployment.getDeploymentID());
        for (TimerData timerData : timerDatas) {
            this.initializeNewTimer(timerData);
        }
    }

    @Override
    public void stop() {
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            try {
                timerData.stop();
            }
            catch (EJBException e) {
                log.error("fail to stop timer", e);
            }
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void schedule(TimerData timerData) {
        if (this.scheduler == null) {
            throw new IllegalStateException("scheduler is configured properly");
        }
        timerData.setScheduler(this.scheduler);
        Trigger trigger = timerData.getTrigger();
        trigger.setJobName(OPENEJB_TIMEOUT_JOB_NAME);
        trigger.setJobGroup(OPENEJB_TIMEOUT_JOB_GROUP_NAME);
        JobDataMap triggerDataMap = trigger.getJobDataMap();
        triggerDataMap.put((Object)"EJB_TIMERS_SERVICE", this);
        triggerDataMap.put((Object)"TIMER_DATA", timerData);
        try {
            this.scheduler.scheduleJob(trigger);
        }
        catch (Exception e) {
            log.warning("Could not schedule timer " + timerData, e);
        }
    }

    public void cancelled(TimerData timerData) {
        this.timerStore.removeTimer(timerData.getId());
    }

    public void addTimerData(TimerData timerData) {
        try {
            this.timerStore.addTimerData(timerData);
        }
        catch (Exception e) {
            log.warning("Could not add timer of type " + timerData.getType().name() + " due to " + e.getMessage());
        }
    }

    @Override
    public Timer getTimer(long timerId) {
        TimerData timerData = this.timerStore.getTimer((String)this.deployment.getDeploymentID(), timerId);
        if (timerData != null) {
            return timerData.getTimer();
        }
        return null;
    }

    @Override
    public Collection<Timer> getTimers(Object primaryKey) throws IllegalStateException {
        this.checkState();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        for (TimerData timerData : this.timerStore.getTimers((String)this.deployment.getDeploymentID())) {
            timers.add(timerData.getTimer());
        }
        return timers;
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration is negative: " + duration);
        }
        this.checkState();
        Date expiration = new Date(System.currentTimeMillis() + duration);
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException(e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration is negative: " + initialDuration);
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException(e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration is null");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration is negative: " + expiration.getTime());
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createSingleActionTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, expiration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException(e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration is null");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration is negative: " + initialExpiration.getTime());
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration is negative: " + intervalDuration);
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createIntervalTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, initialExpiration, intervalDuration, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException(e);
        }
    }

    @Override
    public Timer createTimer(Object primaryKey, Method timeoutMethod, ScheduleExpression scheduleExpression, TimerConfig timerConfig) {
        if (scheduleExpression == null) {
            throw new IllegalArgumentException("scheduleExpression is null");
        }
        this.checkState();
        try {
            TimerData timerData = this.timerStore.createCalendarTimer(this, (String)this.deployment.getDeploymentID(), primaryKey, timeoutMethod, scheduleExpression, timerConfig);
            this.initializeNewTimer(timerData);
            return timerData.getTimer();
        }
        catch (TimerStoreException e) {
            throw new EJBException(e);
        }
    }

    public TimerStore getTimerStore() {
        return this.timerStore;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private void initializeNewTimer(TimerData timerData) {
        timerData.newTimer();
    }

    private void checkState() throws IllegalStateException {
        BaseContext context = (BaseContext)this.deployment.get(EJBContext.class);
        context.check(BaseContext.Call.timerMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void ejbTimeout(TimerData timerData) {
        try {
            Timer timer = this.getTimer(timerData.getId());
            if (timer == null) {
                return;
            }
            for (int tries = 0; tries < 1 + this.retryAttempts; ++tries) {
                boolean retry;
                block59: {
                    retry = false;
                    if (this.transacted) {
                        try {
                            this.transactionManager.begin();
                        }
                        catch (Exception e) {
                            log.warning("Exception occured while starting container transaction", e);
                            if (timerData.getType() == TimerType.SingleAction) {
                                this.timerStore.removeTimer(timerData.getId());
                                timerData.setExpired(true);
                            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                                this.timerStore.removeTimer(timerData.getId());
                                timerData.setExpired(true);
                            } else {
                                this.timerStore.updateIntervalTimer(timerData);
                            }
                            return;
                        }
                    }
                    RpcContainer container = (RpcContainer)this.deployment.getContainer();
                    Method ejbTimeout = timerData.getTimeoutMethod();
                    SetAccessible.on(ejbTimeout);
                    container.invoke(this.deployment.getDeploymentID(), InterfaceType.TIMEOUT, ejbTimeout.getDeclaringClass(), ejbTimeout, new Object[]{timer}, timerData.getPrimaryKey());
                    if (this.transacted) break block59;
                    if (retry) continue;
                    return;
                }
                if (this.transactionManager.getStatus() == 0) {
                    this.transactionManager.commit();
                    return;
                }
                try {
                    this.transactionManager.rollback();
                }
                catch (Exception e) {
                    log.warning("Exception occured while completing container transaction", e);
                }
                continue;
                catch (RuntimeException e) {
                    block60: {
                        retry = true;
                        log.warning("RuntimeException from ejbTimeout on " + this.deployment.getDeploymentID(), e);
                        try {
                            this.transactionManager.setRollbackOnly();
                        }
                        catch (SystemException e1) {
                            log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                        }
                        if (this.transacted) break block60;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e2) {
                        log.warning("Exception occured while completing container transaction", e2);
                    }
                    continue;
                }
                catch (OpenEJBException e2) {
                    block62: {
                        block61: {
                            retry = true;
                            log.warning("Exception from ejbTimeout on " + this.deployment.getDeploymentID(), e2);
                            if (!this.transacted) break block61;
                            try {
                                this.transactionManager.setRollbackOnly();
                            }
                            catch (SystemException e1) {
                                log.warning("Exception occured while setting RollbackOnly for container transaction", e1);
                            }
                            {
                                catch (Throwable throwable) {
                                    block63: {
                                        try {
                                            if (this.transacted) break block63;
                                            if (retry) continue;
                                            if (timerData.getType() == TimerType.SingleAction) {
                                                this.timerStore.removeTimer(timerData.getId());
                                                timerData.setExpired(true);
                                            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                                                this.timerStore.removeTimer(timerData.getId());
                                                timerData.setExpired(true);
                                            } else {
                                                this.timerStore.updateIntervalTimer(timerData);
                                            }
                                            return;
                                        }
                                        catch (Exception e3) {
                                            log.warning("Exception occured while completing container transaction", e3);
                                            throw throwable;
                                        }
                                    }
                                    if (this.transactionManager.getStatus() == 0) {
                                        this.transactionManager.commit();
                                        return;
                                    }
                                    this.transactionManager.rollback();
                                    continue;
                                }
                            }
                        }
                        if (this.transacted) break block62;
                        if (retry) continue;
                        return;
                    }
                    if (this.transactionManager.getStatus() == 0) {
                        this.transactionManager.commit();
                        return;
                    }
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Exception e4) {
                        log.warning("Exception occured while completing container transaction", e4);
                    }
                    continue;
                }
            }
            log.warning("Failed to execute ejbTimeout on " + timerData.getDeploymentId() + " successfully within " + this.retryAttempts + " attempts");
        }
        catch (RuntimeException e) {
            log.warning("RuntimeException occured while calling ejbTimeout", e);
            throw e;
        }
        catch (Error e) {
            log.warning("Error occured while calling ejbTimeout", e);
            throw e;
        }
        finally {
            if (timerData.getType() == TimerType.SingleAction) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else if (timerData.getType() == TimerType.Calendar && timerData.getNextTimeout() == null) {
                this.timerStore.removeTimer(timerData.getId());
                timerData.setExpired(true);
            } else {
                this.timerStore.updateIntervalTimer(timerData);
            }
        }
    }
}

