/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.InputStream;
import java.util.Map;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import javax.xml.bind.JAXBElement;
import org.apache.openejb.assembler.classic.ValidationInfo;
import org.apache.openejb.jee.bval.PropertyType;
import org.apache.openejb.jee.bval.ValidationConfigType;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public final class ValidatorBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, ValidatorBuilder.class);

    private ValidatorBuilder() {
    }

    public static ValidatorFactory buildFactory(ClassLoader classLoader, ValidationInfo info) {
        return ValidatorBuilder.buildFactory(info, classLoader);
    }

    public static ValidationInfo getInfo(ValidationConfigType config) {
        ValidationInfo info = new ValidationInfo();
        if (config != null) {
            info.providerClassName = config.getDefaultProvider();
            info.constraintFactoryClass = config.getConstraintValidatorFactory();
            info.traversableResolverClass = config.getTraversableResolver();
            info.messageInterpolatorClass = config.getMessageInterpolator();
            for (PropertyType propertyType : config.getProperty()) {
                info.propertyTypes.put(propertyType.getName(), propertyType.getValue());
            }
            for (JAXBElement jAXBElement : config.getConstraintMapping()) {
                info.constraintMappings.add((String)jAXBElement.getValue());
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidatorFactory buildFactory(ValidationInfo config, ClassLoader classLoader) {
        ValidatorFactory factory;
        block6: {
            factory = null;
            ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                if (config == null) {
                    factory = Validation.buildDefaultValidatorFactory();
                    break block6;
                }
                Configuration<?> configuration = ValidatorBuilder.getConfig(config);
                try {
                    factory = configuration.buildValidatorFactory();
                }
                catch (ValidationException ve) {
                    Thread.currentThread().setContextClassLoader(ValidatorBuilder.class.getClassLoader());
                    factory = Validation.buildDefaultValidatorFactory();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    logger.warning("Unable create validator factory with config " + config + " (" + ve.getMessage() + ")." + " Default factory will be used.");
                }
                configuration.ignoreXmlConfiguration();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
            }
        }
        return factory;
    }

    private static Configuration<?> getConfig(ValidationInfo info) {
        String constraintFactoryClass;
        String traversableResolverClass;
        Configuration<?> target = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String providerClassName = info.providerClassName;
        if (providerClassName != null) {
            try {
                Class<?> clazz = classLoader.loadClass(providerClassName);
                target = Validation.byProvider(clazz).configure();
                logger.info("Using " + providerClassName + " as validation provider.");
            }
            catch (ClassNotFoundException e) {
                logger.warning("Unable to load provider class " + providerClassName, e);
            }
            catch (ValidationException ve) {
                logger.warning("Unable create validator factory with provider " + providerClassName + " (" + ve.getMessage() + ")." + " Default one will be used.");
            }
        }
        if (target == null) {
            Thread.currentThread().setContextClassLoader(ValidatorBuilder.class.getClassLoader());
            target = Validation.byDefaultProvider().configure();
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        target.ignoreXmlConfiguration();
        String messageInterpolatorClass = info.messageInterpolatorClass;
        if (messageInterpolatorClass != null) {
            try {
                Class<?> clazz = classLoader.loadClass(messageInterpolatorClass);
                target.messageInterpolator((MessageInterpolator)clazz.newInstance());
            }
            catch (Exception e) {
                logger.warning("Unable to set " + messageInterpolatorClass + " as message interpolator.", e);
            }
            logger.info("Using " + messageInterpolatorClass + " as message interpolator.");
        }
        if ((traversableResolverClass = info.traversableResolverClass) != null) {
            try {
                Class<?> clazz = classLoader.loadClass(traversableResolverClass);
                target.traversableResolver((TraversableResolver)clazz.newInstance());
            }
            catch (Exception e) {
                logger.warning("Unable to set " + traversableResolverClass + " as traversable resolver.", e);
            }
            logger.info("Using " + traversableResolverClass + " as traversable resolver.");
        }
        if ((constraintFactoryClass = info.constraintFactoryClass) != null) {
            try {
                Class<?> clazz = classLoader.loadClass(constraintFactoryClass);
                target.constraintValidatorFactory((ConstraintValidatorFactory)clazz.newInstance());
            }
            catch (Exception e) {
                logger.warning("Unable to set " + constraintFactoryClass + " as constraint factory.", e);
            }
            logger.info("Using " + constraintFactoryClass + " as constraint factory.");
        }
        for (Map.Entry<Object, Object> entry : info.propertyTypes.entrySet()) {
            PropertyType property = new PropertyType();
            property.setName((String)entry.getKey());
            property.setValue((String)entry.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug("Found property '" + property.getName() + "' with value '" + property.getValue());
            }
            target.addProperty(property.getName(), property.getValue());
        }
        for (String mappingFileName : info.constraintMappings) {
            InputStream in;
            if (logger.isDebugEnabled()) {
                logger.debug("Opening input stream for " + mappingFileName);
            }
            if ((in = classLoader.getResourceAsStream(mappingFileName)) == null) {
                logger.warning("Unable to open input stream for mapping file " + mappingFileName + ". It will be ignored");
                continue;
            }
            target.addMapping(in);
        }
        return target;
    }
}

