/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.util.ArrayList;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxyHandle;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBObjectProxyHandle;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ServerSideResolver
implements EJBHomeProxyHandle.Resolver,
EJBObjectProxyHandle.Resolver {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");

    public Object resolve(EJBHomeHandler handler) {
        try {
            EJBMetaDataImpl ejb = handler.getEjb();
            InterfaceType interfaceType = ejb.getRemoteInterfaceClass() == null ? InterfaceType.BUSINESS_REMOTE_HOME : InterfaceType.EJB_HOME;
            ArrayList<Class> interfaces = new ArrayList<Class>();
            if (interfaceType.isBusiness()) {
                interfaces.addAll(ejb.getBusinessClasses());
            } else {
                interfaces.add(ejb.getRemoteInterfaceClass());
            }
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            BeanContext beanContext = containerSystem.getBeanContext((Object)ejb.getDeploymentID());
            return EjbHomeProxyHandler.createHomeProxy((BeanContext)beanContext, (InterfaceType)interfaceType, interfaces, (Class)ejb.getMainInterface());
        }
        catch (Exception e) {
            logger.error("ServerSideResolver.resolve() failed, falling back to ClientSideResolver: " + e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            return new EJBHomeProxyHandle.ClientSideResovler().resolve(handler);
        }
    }

    public Object resolve(EJBObjectHandler handler) {
        try {
            EJBMetaDataImpl ejb = handler.getEjb();
            InterfaceType interfaceType = ejb.getRemoteInterfaceClass() == null ? InterfaceType.BUSINESS_REMOTE_HOME : InterfaceType.EJB_HOME;
            ArrayList<Class> interfaces = new ArrayList<Class>();
            if (interfaceType.isBusiness()) {
                interfaces.addAll(ejb.getBusinessClasses());
            } else {
                interfaces.add(ejb.getRemoteInterfaceClass());
            }
            ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            BeanContext beanContext = containerSystem.getBeanContext((Object)ejb.getDeploymentID());
            return EjbObjectProxyHandler.createProxy((BeanContext)beanContext, (Object)handler.getPrimaryKey(), (InterfaceType)interfaceType, interfaces, (Class)ejb.getMainInterface());
        }
        catch (Exception e) {
            logger.error("ServerSideResolver.resolve() failed, falling back to ClientSideResolver: " + e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            return new EJBObjectProxyHandle.ClientSideResovler().resolve(handler);
        }
    }
}

