/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.WriterStreamConsumer;

class ForkedLauncher
implements MavenLauncher {
    private final String mavenHome;
    private final String executable;

    public ForkedLauncher(String mavenHome) {
        this(mavenHome, false);
    }

    public ForkedLauncher(String mavenHome, boolean debugJvm) {
        this.mavenHome = mavenHome;
        String script = debugJvm ? "mvnDebug" : "mvn";
        this.executable = mavenHome != null ? new File(mavenHome, "bin/" + script).getPath() : script;
    }

    public int run(String[] cliArgs, Map envVars, String workingDirectory, File logFile) throws IOException, LauncherException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.executable);
        if (this.mavenHome != null) {
            cmd.addEnvironment("M2_HOME", this.mavenHome);
        }
        if (envVars != null) {
            for (Object o : envVars.keySet()) {
                String key = (String)o;
                cmd.addEnvironment(key, (String)envVars.get(key));
            }
        }
        if (envVars == null || envVars.get("JAVA_HOME") == null) {
            cmd.addEnvironment("JAVA_HOME", System.getProperty("java.home"));
        }
        cmd.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        cmd.setWorkingDirectory(workingDirectory);
        for (String cliArg : cliArgs) {
            cmd.createArg().setValue(cliArg);
        }
        FileWriter logWriter = new FileWriter(logFile);
        WriterStreamConsumer out = new WriterStreamConsumer((Writer)logWriter);
        WriterStreamConsumer err = new WriterStreamConsumer((Writer)logWriter);
        try {
            int cliArg = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
            return cliArg;
        }
        catch (CommandLineException e) {
            throw new LauncherException("Failed to run Maven: " + e.getMessage() + "\n" + cmd, e);
        }
        finally {
            ((Writer)logWriter).close();
        }
    }

    public int run(String[] cliArgs, String workingDirectory, File logFile) throws IOException, LauncherException {
        return this.run(cliArgs, Collections.EMPTY_MAP, workingDirectory, logFile);
    }
}

