/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.deploy.internal;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployer;
import org.apache.maven.shared.transfer.artifact.deploy.ArtifactDeployerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=ArtifactDeployer.class)
class DefaultArtifactDeployer
implements ArtifactDeployer,
Contextualizable {
    private PlexusContainer container;

    DefaultArtifactDeployer() {
    }

    @Override
    public void deploy(ProjectBuildingRequest request, Collection<Artifact> mavenArtifacts) throws ArtifactDeployerException {
        this.validateParameters(request, mavenArtifacts);
        try {
            String hint = DefaultArtifactDeployer.isMaven31() ? "maven31" : "maven3";
            ArtifactDeployer effectiveArtifactDeployer = (ArtifactDeployer)this.container.lookup(ArtifactDeployer.class, hint);
            effectiveArtifactDeployer.deploy(request, mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactDeployerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void deploy(ProjectBuildingRequest request, ArtifactRepository remoteRepository, Collection<Artifact> mavenArtifacts) throws ArtifactDeployerException {
        this.validateParameters(request, mavenArtifacts);
        try {
            String hint = DefaultArtifactDeployer.isMaven31() ? "maven31" : "maven3";
            ArtifactDeployer effectiveArtifactDeployer = (ArtifactDeployer)this.container.lookup(ArtifactDeployer.class, hint);
            effectiveArtifactDeployer.deploy(request, remoteRepository, mavenArtifacts);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactDeployerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void validateParameters(ProjectBuildingRequest request, Collection<Artifact> mavenArtifacts) {
        if (request == null) {
            throw new IllegalArgumentException("The parameter request is not allowed to be null.");
        }
        if (mavenArtifacts == null) {
            throw new IllegalArgumentException("The parameter mavenArtifacts is not allowed to be null.");
        }
        if (mavenArtifacts.isEmpty()) {
            throw new IllegalArgumentException("The collection mavenArtifacts is not allowed to be empty.");
        }
    }

    protected static boolean isMaven31() {
        return DefaultArtifactDeployer.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

