/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamAddConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private String workingDirectory;
    private String currentDir;
    private List files = new ArrayList();
    private static final String DIR_MARKER = "(working dir: ";
    private static final String ADDED_MARKER = ": added";
    private static final String LINKTO_MARKER = ": linked to";

    public StarteamAddConsumer(ScmLogger logger, File basedir) {
        this.logger = logger;
        this.workingDirectory = basedir.getPath().replace('\\', '/');
    }

    public void consumeLine(String line) {
        this.logger.debug(line);
        int pos = 0;
        pos = line.indexOf(DIR_MARKER);
        if (pos != -1) {
            this.processDirectory(line, pos);
        } else {
            pos = line.indexOf(ADDED_MARKER);
            if (pos != -1) {
                this.processAddedFile(line, pos);
            } else {
                pos = line.indexOf(LINKTO_MARKER);
                if (pos == -1) {
                    this.logger.warn("Unknown add ouput: " + line);
                }
            }
        }
    }

    public List getAddedFiles() {
        return this.files;
    }

    private void processDirectory(String line, int pos) {
        String dirPath = line.substring(pos + DIR_MARKER.length(), line.length() - 1).replace('\\', '/');
        try {
            this.currentDir = StarteamCommandLineUtils.getRelativeChildDirectory(this.workingDirectory, dirPath);
        }
        catch (IllegalStateException e) {
            String error = "Working and checkout directories are not on the same tree";
            this.logger.error(error);
            this.logger.error("Working directory: " + this.workingDirectory);
            this.logger.error("Checked out directory: " + dirPath);
            throw new IllegalStateException(error);
        }
    }

    private void processAddedFile(String line, int pos) {
        String addedFilePath = this.currentDir + "/" + line.substring(0, pos);
        this.files.add(new ScmFile(addedFilePath, ScmFileStatus.ADDED));
        this.logger.info("Added: " + addedFilePath);
    }
}

