/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.PropertyUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWarMojo
extends AbstractMojo {
    private MavenProject project;
    private File classesDirectory;
    private File webappDirectory;
    private File warSourceDirectory;
    private Resource[] webResources;
    private List filters;
    private File webXml;
    private File containerConfigXML;
    private File workDirectory;
    protected ArchiverManager archiverManager;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private String warSourceIncludes = "**";
    private String warSourceExcludes;
    private String dependentWarIncludes = "**";
    private String dependentWarExcludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
            excludeList.add("**/WEB-INF/web.xml");
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        webappDirectory.mkdirs();
        File webinfDir = new File(webappDirectory, WEB_INF);
        webinfDir.mkdirs();
        File metainfDir = new File(webappDirectory, META_INF);
        metainfDir.mkdirs();
        try {
            List<Resource> webResources;
            List<Resource> list = webResources = this.webResources != null ? Arrays.asList(this.webResources) : null;
            if (webResources != null && webResources.size() > 0) {
                Properties filterProperties = this.getBuildFilterProperties();
                Iterator<Resource> it = webResources.iterator();
                while (it.hasNext()) {
                    Resource resource = it.next();
                    this.copyResources(resource, webappDirectory, filterProperties);
                }
            }
            this.copyResources(this.warSourceDirectory, webappDirectory);
            if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
                AbstractWarMojo.copyFileIfModified(this.webXml, new File(webinfDir, "/web.xml"));
            }
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                metainfDir = new File(webappDirectory, META_INF);
                String xmlFileName = this.containerConfigXML.getName();
                AbstractWarMojo.copyFileIfModified(this.containerConfigXML, new File(metainfDir, xmlFileName));
            }
            this.buildWebapp(this.project, webappDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
    }

    private Properties getBuildFilterProperties() throws MojoExecutionException {
        Properties filterProperties = new Properties(System.getProperties());
        ((Hashtable)filterProperties).putAll(this.project.getProperties());
        Iterator i = this.filters.iterator();
        while (i.hasNext()) {
            String filtersfile = (String)i.next();
            try {
                Properties properties = PropertyUtils.loadPropertyFile(new File(filtersfile), true, true);
                ((Hashtable)filterProperties).putAll(properties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading property file '" + filtersfile + "'", (Exception)e);
            }
        }
        return filterProperties;
    }

    public void copyResources(Resource resource, File webappDirectory, Properties filterProperties) throws IOException {
        if (!resource.getDirectory().equals(webappDirectory.getPath())) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (webappDirectory.exists()) {
                String[] fileNames = this.getWarFiles(resource);
                for (int i = 0; i < fileNames.length; ++i) {
                    if (resource.isFiltering()) {
                        AbstractWarMojo.copyFilteredFile(new File(resource.getDirectory(), fileNames[i]), new File(webappDirectory, fileNames[i]), null, this.getFilterWrappers(), filterProperties);
                        continue;
                    }
                    AbstractWarMojo.copyFileIfModified(new File(resource.getDirectory(), fileNames[i]), new File(webappDirectory, fileNames[i]));
                }
            }
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (this.warSourceDirectory.exists()) {
                String[] fileNames = this.getWarFiles(sourceDirectory);
                for (int i = 0; i < fileNames.length; ++i) {
                    AbstractWarMojo.copyFileIfModified(new File(sourceDirectory, fileNames[i]), new File(webappDirectory, fileNames[i]));
                }
            }
        }
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        File webappClassesDirectory = new File(webappDirectory, "WEB-INF/classes");
        if (this.classesDirectory.exists() && !this.classesDirectory.equals(webappClassesDirectory)) {
            AbstractWarMojo.copyDirectoryStructureIfModified(this.classesDirectory, webappClassesDirectory);
        }
        Set artifacts = project.getArtifacts();
        List duplicates = this.findDuplicates(artifacts);
        ArrayList<File> dependentWarDirectories = new ArrayList<File>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String targetFileName = this.getDefaultFinalName(artifact);
            this.getLog().debug((CharSequence)("Processing: " + targetFileName));
            if (duplicates.contains(targetFileName)) {
                this.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                targetFileName = artifact.getGroupId() + "-" + targetFileName;
                this.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            String type = artifact.getType();
            if ("tld".equals(type)) {
                AbstractWarMojo.copyFileIfModified(artifact.getFile(), new File(tldDirectory, targetFileName));
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                AbstractWarMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("par".equals(type)) {
                targetFileName = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                this.getLog().debug((CharSequence)("Copying " + artifact.getFile() + " to " + new File(libDirectory, targetFileName)));
                AbstractWarMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("war".equals(type)) {
                dependentWarDirectories.add(this.unpackWarToTempDirectory(artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
        if (dependentWarDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependentWarDirectories.size() + " war(s)."));
            iter = dependentWarDirectories.iterator();
            while (iter.hasNext()) {
                this.copyDependentWarContents((File)iter.next(), webappDirectory);
            }
        }
    }

    private List findDuplicates(Set artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private File unpackWarToTempDirectory(Artifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!tempLocation.exists()) {
            tempLocation.mkdirs();
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    private void copyDependentWarContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependentWarExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependentWarIncludes());
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(targetDir, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File targetFile = new File(targetDir, files[j]);
            if (targetFile.exists()) continue;
            try {
                targetFile.getParentFile().mkdirs();
                AbstractWarMojo.copyFileIfModified(new File(srcDir, files[j]), targetFile);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String[] getWarFiles(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static void copyFileToDirectoryIfModified(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        AbstractWarMojo.copyFileIfModified(source, new File(destinationDirectory, source.getName()));
    }

    private FilterWrapper[] getFilterWrappers() {
        return new FilterWrapper[]{new FilterWrapper(){

            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "${", "}");
            }
        }, new FilterWrapper(){

            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "@", "@");
            }
        }};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFilteredFile(File from, File to, String encoding, FilterWrapper[] wrappers, Properties filterProperties) throws IOException {
        BufferedReader fileReader = null;
        OutputStreamWriter fileWriter = null;
        try {
            to.getParentFile().mkdirs();
            if (encoding == null || encoding.length() < 1) {
                fileReader = new BufferedReader(new FileReader(from));
                fileWriter = new FileWriter(to);
            } else {
                FileInputStream instream = new FileInputStream(from);
                FileOutputStream outstream = new FileOutputStream(to);
                fileReader = new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
                fileWriter = new OutputStreamWriter((OutputStream)outstream, encoding);
            }
            Reader reader = fileReader;
            for (int i = 0; i < wrappers.length; ++i) {
                FilterWrapper wrapper = wrappers[i];
                reader = wrapper.getReader(reader, filterProperties);
            }
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    private static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source, (File)destination);
        }
    }

    private static void copyDirectoryStructureIfModified(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        File[] files = sourceDirectory.listFiles();
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                AbstractWarMojo.copyFileToDirectoryIfModified(file, destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                AbstractWarMojo.copyDirectoryStructureIfModified(file, destination);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getType();
    }

    private static interface FilterWrapper {
        public Reader getReader(Reader var1, Properties var2);
    }
}

