/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeps;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jdeps.AbstractJDepsMojo;

@Mojo(name="jdkinternals", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class JDKInternalsMojo
extends AbstractJDepsMojo {
    @Override
    protected String getClassesDirectory() {
        return this.getProject().getBuild().getOutputDirectory();
    }

    @Override
    protected Collection<Path> getClassPath() throws DependencyResolutionRequiredException {
        LinkedHashSet<Path> classPath = new LinkedHashSet<Path>(this.getProject().getCompileClasspathElements().size());
        for (String elm : this.getProject().getCompileClasspathElements()) {
            classPath.add(Paths.get(elm, new String[0]));
        }
        return classPath;
    }
}

