/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ejb;

import java.io.File;

public final class EjbHelper {
    private EjbHelper() {
    }

    public static boolean isClassifierValid(String classifier) {
        boolean result = false;
        if (EjbHelper.hasClassifier(classifier) && classifier.matches("^[a-zA-Z]+[0-9a-zA-Z\\-]*")) {
            result = true;
        }
        return result;
    }

    public static boolean hasClassifier(String classifier) {
        boolean result = false;
        if (classifier != null && classifier.trim().length() > 0) {
            result = true;
        }
        return result;
    }

    public static File getJarFile(File basedir, String finalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (finalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        StringBuilder fileName = new StringBuilder(finalName);
        if (EjbHelper.hasClassifier(classifier)) {
            fileName.append("-").append(classifier);
        }
        fileName.append(".jar");
        return new File(basedir, fileName.toString());
    }
}

