/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;

public class RadManifestWriter
extends AbstractEclipseWriter {
    private static final String MANIFEST_MF_FILENAME = "MANIFEST.MF";
    private static final String META_INF_DIRECTORY = "META-INF";
    private static final String WEBAPP_RESOURCE_DIR = "src" + File.separatorChar + "main" + File.separatorChar + "webapp";

    private String getMetaInfBaseDirectory(MavenProject project) {
        String metaInfBaseDirectory = null;
        if (this.config.getProject().getPackaging().equals("war")) {
            metaInfBaseDirectory = this.config.getProject().getBasedir().getAbsolutePath() + File.separatorChar + WEBAPP_RESOURCE_DIR;
            this.log.debug((CharSequence)("Attempting to use: " + metaInfBaseDirectory + " for location of META-INF in war project."));
            File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY);
            if (metaInfDirectoryFile.exists() && !metaInfDirectoryFile.isDirectory()) {
                metaInfBaseDirectory = null;
            }
        }
        if (metaInfBaseDirectory == null) {
            Iterator iterator = project.getResources().iterator();
            while (iterator.hasNext()) {
                metaInfBaseDirectory = ((Resource)iterator.next()).getDirectory();
                File metaInfDirectoryFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY);
                this.log.debug((CharSequence)("Checking for existence of META-INF directory: " + metaInfDirectoryFile));
                if (!metaInfDirectoryFile.exists() || metaInfDirectoryFile.isDirectory()) continue;
                metaInfBaseDirectory = null;
            }
        }
        return metaInfBaseDirectory;
    }

    public void write() throws MojoExecutionException {
        String metaInfBaseDirectory = this.getMetaInfBaseDirectory(this.config.getProject());
        if (metaInfBaseDirectory == null) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", new Object[]{META_INF_DIRECTORY}));
        }
        Manifest manifest = this.createNewManifest();
        File manifestFile = new File(metaInfBaseDirectory + File.separatorChar + META_INF_DIRECTORY + File.separatorChar + MANIFEST_MF_FILENAME);
        System.out.println("MANIFEST LOCATION: " + manifestFile);
        if (this.shouldNewManifestFileBeWritten(manifest, manifestFile)) {
            System.out.println("Writing manifest...");
            manifestFile.getParentFile().mkdirs();
            try {
                FileOutputStream stream = new FileOutputStream(manifestFile);
                manifest.write(stream);
                stream.close();
                this.verifyManifestBasedirInSourceDirs(metaInfBaseDirectory);
            }
            catch (Exception e) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.cantwritetofile", new Object[]{metaInfBaseDirectory + File.separatorChar + MANIFEST_MF_FILENAME}));
            }
        }
    }

    private void verifyManifestBasedirInSourceDirs(String metaInfBaseDirectory) {
        EclipseSourceDir[] sourceDirs = this.config.getSourceDirs();
        if (sourceDirs != null) {
            boolean foundMetaInfBaseDirectory = false;
            for (int i = 0; i < sourceDirs.length; ++i) {
                EclipseSourceDir esd = sourceDirs[i];
                if (!esd.getPath().equals(metaInfBaseDirectory)) continue;
                foundMetaInfBaseDirectory = true;
                break;
            }
            if (!foundMetaInfBaseDirectory) {
                EclipseSourceDir dir = new EclipseSourceDir(metaInfBaseDirectory, null, true, false, null, null, false);
                EclipseSourceDir[] newSourceDirs = new EclipseSourceDir[sourceDirs.length + 1];
                newSourceDirs[sourceDirs.length] = dir;
                System.arraycopy(sourceDirs, 0, newSourceDirs, 0, sourceDirs.length);
                this.config.setSourceDirs(newSourceDirs);
            }
        }
    }

    private void addDependencyToClassPath(StringBuffer classpath, IdeDependency dependency) {
        if (!dependency.isTestDependency() && !dependency.isProvided()) {
            if (classpath.length() != 0) {
                classpath.append(' ');
            }
            if (!dependency.isReferencedProject()) {
                classpath.append(dependency.getFile().getName());
            } else {
                classpath.append(dependency.getArtifactId() + ".jar");
            }
        }
    }

    private boolean areManifestsEqual(Manifest manifest, Manifest existingManifest) {
        if (existingManifest == null) {
            return false;
        }
        HashSet<Object> keys = new HashSet<Object>();
        Attributes existingMap = existingManifest.getMainAttributes();
        Attributes newMap = manifest.getMainAttributes();
        keys.addAll(existingMap.keySet());
        keys.addAll(newMap.keySet());
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Attributes.Name key = (Attributes.Name)iterator.next();
            String newValue = (String)newMap.get(key);
            String existingValue = (String)existingMap.get(key);
            if (Attributes.Name.CLASS_PATH.equals(key)) {
                newValue = this.orderClasspath(newValue);
                existingValue = this.orderClasspath(existingValue);
            }
            if (newValue != null && newValue.equals(existingValue) || existingValue != null && existingValue.equals(newValue)) continue;
            return false;
        }
        return true;
    }

    private String constructManifestClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        IdeDependency[] deps = this.config.getDeps();
        for (int index = 0; index < deps.length; ++index) {
            this.addDependencyToClassPath(stringBuffer, deps[index]);
        }
        return stringBuffer.toString();
    }

    private Manifest createNewManifest() {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, this.constructManifestClasspath());
        return manifest;
    }

    private String orderClasspath(String newValue) {
        Object[] entries = newValue.split(" ");
        Arrays.sort(entries);
        StringBuffer buffer = new StringBuffer(newValue.length());
        for (int index = 0; index < entries.length; ++index) {
            buffer.append((String)entries[index]);
            buffer.append(' ');
        }
        return buffer.toString();
    }

    private Manifest readExistingManifest(File manifestFile) throws IOException {
        if (!manifestFile.exists()) {
            return null;
        }
        Manifest existingManifest = new Manifest();
        FileInputStream inputStream = new FileInputStream(manifestFile);
        existingManifest.read(inputStream);
        inputStream.close();
        return existingManifest;
    }

    private boolean shouldNewManifestFileBeWritten(Manifest manifest, File manifestFile) throws MojoExecutionException {
        try {
            Manifest existingManifest = this.readExistingManifest(manifestFile);
            if (this.areManifestsEqual(manifest, existingManifest)) {
                this.log.info((CharSequence)Messages.getString("EclipseCleanMojo.unchanged", manifestFile.getAbsolutePath()));
                return false;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(Messages.getString("EclipseCleanMojo.nofilefound", manifestFile.getAbsolutePath()), e);
        }
        return true;
    }
}

