/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.Ejb3Module;
import org.apache.maven.plugin.ear.EjbClientModule;
import org.apache.maven.plugin.ear.EjbModule;
import org.apache.maven.plugin.ear.HarModule;
import org.apache.maven.plugin.ear.JarModule;
import org.apache.maven.plugin.ear.ParModule;
import org.apache.maven.plugin.ear.RarModule;
import org.apache.maven.plugin.ear.SarModule;
import org.apache.maven.plugin.ear.UnknownArtifactTypeException;
import org.apache.maven.plugin.ear.WebModule;
import org.apache.maven.plugin.ear.WsrModule;
import org.apache.maven.plugin.ear.util.ArtifactTypeMappingService;
import org.apache.maven.plugin.ear.util.JavaEEVersion;

public final class EarModuleFactory {
    public static final List standardArtifactTypes;

    public static EarModule newEarModule(Artifact artifact, JavaEEVersion javaEEVersion, String defaultLibBundleDir, Boolean includeInApplicationXml, ArtifactTypeMappingService typeMappingService) throws UnknownArtifactTypeException {
        String artifactType = typeMappingService.getStandardType(artifact.getType());
        if ("jar".equals(artifactType)) {
            return new JarModule(artifact, defaultLibBundleDir, includeInApplicationXml);
        }
        if ("ejb".equals(artifactType)) {
            return new EjbModule(artifact);
        }
        if ("ejb3".equals(artifactType)) {
            return new Ejb3Module(artifact);
        }
        if ("par".equals(artifactType)) {
            return new ParModule(artifact);
        }
        if ("ejb-client".equals(artifactType)) {
            if (javaEEVersion.le(JavaEEVersion.OneDotFour)) {
                return new EjbClientModule(artifact, null);
            }
            return new EjbClientModule(artifact, defaultLibBundleDir);
        }
        if ("rar".equals(artifactType)) {
            return new RarModule(artifact);
        }
        if ("war".equals(artifactType)) {
            return new WebModule(artifact);
        }
        if ("sar".equals(artifactType)) {
            return new SarModule(artifact);
        }
        if ("wsr".equals(artifactType)) {
            return new WsrModule(artifact);
        }
        if ("har".equals(artifactType)) {
            return new HarModule(artifact);
        }
        throw new IllegalStateException("Could not handle artifact type[" + artifactType + "]");
    }

    public static List getStandardArtifactTypes() {
        return standardArtifactTypes;
    }

    public static boolean isStandardArtifactType(String type) {
        return standardArtifactTypes.contains(type);
    }

    static {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add("jar");
        temp.add("ejb");
        temp.add("ejb3");
        temp.add("par");
        temp.add("ejb-client");
        temp.add("rar");
        temp.add("war");
        temp.add("sar");
        temp.add("wsr");
        temp.add("har");
        standardArtifactTypes = Collections.unmodifiableList(temp);
    }
}

