/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public abstract class AbstractDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${settings.offline}", readonly=true)
    private boolean offline;
    @Parameter(property="retryFailedDeploymentCount", defaultValue="1")
    private int retryFailedDeploymentCount;
    @Component
    private RuntimeInformation runtimeInformation;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected RepositorySystem repositorySystem;
    private static final String AFFECTED_MAVEN_PACKAGING = "maven-plugin";
    private static final String FIXED_MAVEN_VERSION = "3.9.0";

    void failIfOffline() throws MojoFailureException {
        if (this.offline) {
            throw new MojoFailureException("Cannot deploy artifacts when Maven is in offline mode");
        }
    }

    protected void warnIfAffectedPackagingAndMaven(String packaging) {
        if (AFFECTED_MAVEN_PACKAGING.equals(packaging)) {
            try {
                GenericVersionScheme versionScheme = new GenericVersionScheme();
                GenericVersion fixedMavenVersion = versionScheme.parseVersion(FIXED_MAVEN_VERSION);
                GenericVersion currentMavenVersion = versionScheme.parseVersion(this.runtimeInformation.getMavenVersion());
                if (fixedMavenVersion.compareTo((Object)currentMavenVersion) > 0) {
                    this.getLog().warn((CharSequence)"");
                    this.getLog().warn((CharSequence)("You are about to deploy a maven-plugin using Maven " + currentMavenVersion + "."));
                    this.getLog().warn((CharSequence)"This plugin should be used ONLY with Maven 3.9.0 and newer, as MNG-7055");
                    this.getLog().warn((CharSequence)"is fixed in those versions of Maven only!");
                    this.getLog().warn((CharSequence)"");
                }
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
    }

    protected RemoteRepository getRemoteRepository(String repositoryId, String url) {
        RemoteRepository result = new RemoteRepository.Builder(repositoryId, "default", url).build();
        if (result.getAuthentication() == null || result.getProxy() == null) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(result);
            if (result.getAuthentication() == null) {
                builder.setAuthentication(this.session.getRepositorySession().getAuthenticationSelector().getAuthentication(result));
            }
            if (result.getProxy() == null) {
                builder.setProxy(this.session.getRepositorySession().getProxySelector().getProxy(result));
            }
            result = builder.build();
        }
        return result;
    }

    protected void deploy(DeployRequest deployRequest) throws MojoExecutionException {
        int retryFailedDeploymentCounter = Math.max(1, Math.min(10, this.retryFailedDeploymentCount));
        DeploymentException exception = null;
        for (int count = 0; count < retryFailedDeploymentCounter; ++count) {
            try {
                if (count > 0) {
                    this.getLog().info((CharSequence)("Retrying deployment attempt " + (count + 1) + " of " + retryFailedDeploymentCounter));
                }
                this.repositorySystem.deploy(this.session.getRepositorySession(), deployRequest);
                exception = null;
                break;
            }
            catch (DeploymentException e) {
                if (count + 1 < retryFailedDeploymentCounter) {
                    this.getLog().warn((CharSequence)("Encountered issue during deployment: " + e.getLocalizedMessage()));
                    this.getLog().debug((Throwable)e);
                }
                if (exception != null) continue;
                exception = e;
                continue;
            }
        }
        if (exception != null) {
            throw new MojoExecutionException(exception.getMessage(), exception);
        }
    }
}

