/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractFromDependenciesMojo;
import org.apache.maven.plugin.dependency.utils.DependencyStatusSets;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.MarkerFileFilter;
import org.apache.maven.plugin.dependency.utils.markers.DefaultFileMarkerHandler;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="unpack-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class UnpackDependenciesMojo
extends AbstractFromDependenciesMojo {
    private String includes;
    private String excludes;

    public void execute() throws MojoExecutionException {
        DependencyStatusSets dss = this.getDependencySets(this.failOnMissingClassifierArtifact);
        for (Artifact artifact : dss.getResolvedDependencies()) {
            File destDir = DependencyUtil.getFormattedOutputDirectory(this.useSubDirectoryPerScope, this.useSubDirectoryPerType, this.useSubDirectoryPerArtifact, this.useRepositoryLayout, this.stripVersion, this.outputDirectory, artifact);
            this.unpack(artifact.getFile(), destDir, this.getIncludes(), this.getExcludes());
            DefaultFileMarkerHandler handler = new DefaultFileMarkerHandler(artifact, this.markersDirectory);
            handler.setMarker();
        }
        for (Artifact artifact : dss.getSkippedDependencies()) {
            this.getLog().info((CharSequence)(artifact.getFile().getName() + " already exists in destination."));
        }
    }

    protected ArtifactsFilter getMarkedArtifactFilter() {
        return new MarkerFileFilter(this.overWriteReleases, this.overWriteSnapshots, this.overWriteIfNewer, new DefaultFileMarkerHandler(this.markersDirectory));
    }

    public String getExcludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.excludes);
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.includes);
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

