/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.markers;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.utils.markers.MarkerHandler;

public class DefaultFileMarkerHandler
implements MarkerHandler {
    protected Artifact artifact;
    protected File markerFilesDirectory;

    public DefaultFileMarkerHandler(File theMarkerFilesDirectory) {
        this.markerFilesDirectory = theMarkerFilesDirectory;
    }

    public DefaultFileMarkerHandler(Artifact theArtifact, File theMarkerFilesDirectory) {
        this.artifact = theArtifact;
        this.markerFilesDirectory = theMarkerFilesDirectory;
    }

    protected File getMarkerFile() {
        return new File(this.markerFilesDirectory, this.artifact.getId().replace(':', '-') + ".marker");
    }

    public boolean isMarkerSet() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        return marker.exists();
    }

    public boolean isMarkerOlder(Artifact artifact1) throws MojoExecutionException {
        System.out.println("> isMarkerOlder:");
        File marker = this.getMarkerFile();
        System.out.println("  artifact1 = " + artifact1.getFile().getPath());
        System.out.println("  marker    = " + marker.getPath());
        if (marker.exists()) {
            System.out.println("    artifact1 lastModified: " + artifact1.getFile().lastModified());
            System.out.println("    marker lastModified: " + marker.lastModified());
            System.out.println("< " + (artifact1.getFile().lastModified() > marker.lastModified()) + " = marker older than artifact?");
            return artifact1.getFile().lastModified() > marker.lastModified();
        }
        System.out.println("< true : marker does not exist");
        return true;
    }

    public void setMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        try {
            marker.getParentFile().mkdirs();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            marker.createNewFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create Marker: " + marker.getAbsolutePath(), (Exception)e);
        }
        try {
            long ts = this.artifact != null && this.artifact.getFile() != null ? this.artifact.getFile().lastModified() : System.currentTimeMillis();
            marker.setLastModified(ts);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to update Marker timestamp: " + marker.getAbsolutePath(), e);
        }
    }

    public boolean clearMarker() throws MojoExecutionException {
        File marker = this.getMarkerFile();
        return marker.delete();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public File getMarkerFilesDirectory() {
        return this.markerFilesDirectory;
    }

    public void setMarkerFilesDirectory(File markerFilesDirectory) {
        this.markerFilesDirectory = markerFilesDirectory;
    }
}

