/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ChangesReportGenerator;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class ChangesMojo
extends AbstractChangesReport {
    private boolean addActionDate;
    private boolean escapeHTML;
    private File filteredOutputDirectory;
    private boolean filteringChanges;
    private String issueLinkTemplate;
    private Map issueLinkTemplatePerSystem;
    private MavenFileFilter mavenFileFilter;
    private String publishDateFormat;
    private String publishDateLocale;
    protected MavenSession session;
    private String system;
    private String teamlist;
    private String url;
    private File xmlPath;
    private CaseInsensitiveMap caseInsensitiveIssueLinkTemplatePerSystem;

    public boolean canGenerateReport() {
        return this.xmlPath.isFile();
    }

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.xmlPath.exists()) {
            this.getLog().warn((CharSequence)("changes.xml file " + this.xmlPath.getAbsolutePath() + " does not exist."));
            return;
        }
        if (this.filteringChanges) {
            if (!this.filteredOutputDirectory.exists()) {
                this.filteredOutputDirectory.mkdirs();
            }
            XmlStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = ReaderFactory.newXmlReader((File)this.xmlPath);
                String encoding = xmlStreamReader.getEncoding();
                File resultFile = new File(this.filteredOutputDirectory, "changes.xml");
                Date now = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.publishDateFormat, new Locale(this.publishDateLocale));
                Properties additionalProperties = new Properties();
                additionalProperties.put("publishDate", simpleDateFormat.format(now));
                MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest(this.xmlPath, resultFile, true, this.project, Collections.EMPTY_LIST, false, encoding, this.session, additionalProperties);
                this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                this.xmlPath = resultFile;
            }
            catch (IOException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)e);
            }
            catch (MavenFilteringException e) {
                throw new MavenReportException("Exception during filtering changes file : " + e.getMessage(), (Exception)((Object)e));
            }
            finally {
                if (xmlStreamReader != null) {
                    IOUtil.close((Reader)xmlStreamReader);
                }
            }
        }
        ChangesXML changesXml = new ChangesXML(this.xmlPath, this.getLog());
        ChangesReportGenerator report = new ChangesReportGenerator(changesXml.getReleaseList());
        report.setAuthor(changesXml.getAuthor());
        report.setTitle(changesXml.getTitle());
        report.setEscapeHTML(this.escapeHTML);
        this.caseInsensitiveIssueLinkTemplatePerSystem = this.issueLinkTemplatePerSystem == null ? new CaseInsensitiveMap() : new CaseInsensitiveMap(this.issueLinkTemplatePerSystem);
        this.addIssueLinkTemplate("default", this.issueLinkTemplate);
        this.addIssueLinkTemplate("Bitbucket", "%URL%/issue/%ISSUE%");
        this.addIssueLinkTemplate("Bugzilla", "%URL%/show_bug.cgi?id=%ISSUE%");
        this.addIssueLinkTemplate("GitHub", "%URL%/%ISSUE%");
        this.addIssueLinkTemplate("GoogleCode", "%URL%/detail?id=%ISSUE%");
        this.addIssueLinkTemplate("JIRA", "%URL%/%ISSUE%");
        this.addIssueLinkTemplate("Mantis", "%URL%/view.php?id=%ISSUE%");
        this.addIssueLinkTemplate("MKS", "%URL%/viewissue?selection=%ISSUE%");
        this.addIssueLinkTemplate("Redmine", "%URL%/issues/show/%ISSUE%");
        this.addIssueLinkTemplate("Scarab", "%URL%/issues/id/%ISSUE%");
        this.addIssueLinkTemplate("SourceForge", "http://sourceforge.net/support/tracker.php?aid=%ISSUE%");
        this.addIssueLinkTemplate("Trac", "%URL%/ticket/%ISSUE%");
        this.addIssueLinkTemplate("YouTrack", "%URL%/issue/%ISSUE%");
        this.logIssueLinkTemplatePerSystem((Map)this.caseInsensitiveIssueLinkTemplatePerSystem);
        report.setIssueLinksPerSystem((Map)this.caseInsensitiveIssueLinkTemplatePerSystem);
        report.setSystem(this.system);
        report.setTeamlist(this.teamlist);
        report.setUrl(this.url);
        report.setAddActionDate(this.addActionDate);
        if (StringUtils.isEmpty((String)this.url)) {
            this.getLog().warn((CharSequence)"No issue management URL defined in POM. Links to your issues will not work correctly.");
        }
        report.doGenerateReport(this.getBundle(locale), this.getSink());
        this.copyStaticResources();
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getOutputName() {
        return "changes-report";
    }

    private void addIssueLinkTemplate(String system, String issueLinkTemplate) {
        if (this.caseInsensitiveIssueLinkTemplatePerSystem == null) {
            this.caseInsensitiveIssueLinkTemplatePerSystem = new CaseInsensitiveMap();
        }
        if (!this.caseInsensitiveIssueLinkTemplatePerSystem.containsKey((Object)system)) {
            this.caseInsensitiveIssueLinkTemplatePerSystem.put((Object)system, (Object)issueLinkTemplate);
        }
    }

    private void copyStaticResources() throws MavenReportException {
        String pluginResourcesBase = "org/apache/maven/plugin/changes";
        String[] resourceNames = new String[]{"images/add.gif", "images/fix.gif", "images/icon_help_sml.gif", "images/remove.gif", "images/rss.png", "images/update.gif"};
        try {
            this.getLog().debug((CharSequence)"Copying static resources.");
            for (int i = 0; i < resourceNames.length; ++i) {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("org/apache/maven/plugin/changes/" + resourceNames[i]);
                FileUtils.copyURLToFile((URL)url, (File)new File(this.getReportOutputDirectory(), resourceNames[i]));
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Unable to copy static resources.");
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("changes-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected String getTeamlist() {
        return this.teamlist;
    }

    private void logIssueLinkTemplatePerSystem(Map issueLinkTemplatePerSystem) {
        if (this.getLog().isDebugEnabled()) {
            if (issueLinkTemplatePerSystem == null) {
                this.getLog().debug((CharSequence)"No issueLinkTemplatePerSystem configuration was found");
            } else {
                for (Map.Entry entry : issueLinkTemplatePerSystem.entrySet()) {
                    this.getLog().debug((CharSequence)("issueLinkTemplatePerSystem[" + entry.getKey() + "] = " + entry.getValue()));
                }
            }
        }
    }
}

