/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.changes;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.ReleaseUtils;
import org.apache.maven.plugins.changes.model.Release;

public class ChangesCheckMojo
extends AbstractMojo {
    private String releaseDateFormat;
    private String version;
    private File xmlPath;
    private ReleaseUtils releaseUtils = new ReleaseUtils(this.getLog());

    public void execute() throws MojoExecutionException {
        if (this.xmlPath.exists()) {
            ChangesXML xml = new ChangesXML(this.xmlPath, this.getLog());
            ReleaseUtils releaseUtils = new ReleaseUtils(this.getLog());
            Release release = releaseUtils.getLatestRelease(releaseUtils.convertReleaseList(xml.getReleaseList()), this.version);
            if (!ChangesCheckMojo.isValidDate(release.getDateRelease(), this.releaseDateFormat)) {
                throw new MojoExecutionException("The file " + this.xmlPath.getAbsolutePath() + " has an invalid release date.");
            }
        } else {
            this.getLog().warn((CharSequence)("The file " + this.xmlPath.getAbsolutePath() + " does not exist."));
        }
    }

    protected static boolean isValidDate(String string, String pattern) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        if (StringUtils.isEmpty((String)pattern)) {
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            df.parse(string);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

