/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.phase;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugin.assembly.archive.task.AddDependencySetsTask;
import org.apache.maven.plugin.assembly.archive.task.AddFileSetsTask;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.DependencySet;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.model.ModuleBinaries;
import org.apache.maven.plugin.assembly.model.ModuleSet;
import org.apache.maven.plugin.assembly.model.ModuleSources;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.FilterUtils;
import org.apache.maven.plugin.assembly.utils.ProjectUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=AssemblyArchiverPhase.class, hint="module-sets")
public class ModuleSetAssemblyPhase
extends AbstractLogEnabled
implements AssemblyArchiverPhase {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @Requirement
    private MavenProjectBuilder projectBuilder;
    @Requirement
    private ArchiverManager archiverManager;

    public ModuleSetAssemblyPhase() {
    }

    public ModuleSetAssemblyPhase(MavenProjectBuilder projectBuilder, Logger logger) {
        this.projectBuilder = projectBuilder;
        this.enableLogging(logger);
    }

    @Override
    public void execute(Assembly assembly, Archiver archiver, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        List<ModuleSet> moduleSets = assembly.getModuleSets();
        for (ModuleSet moduleSet : moduleSets) {
            this.validate(moduleSet, configSource);
            Set<MavenProject> moduleProjects = ModuleSetAssemblyPhase.getModuleProjects(moduleSet, configSource, this.getLogger());
            ModuleSources sources = moduleSet.getSources();
            this.addModuleSourceFileSets(sources, moduleProjects, archiver, configSource);
            ModuleBinaries binaries = moduleSet.getBinaries();
            this.addModuleBinaries(binaries, moduleProjects, archiver, configSource, context);
        }
    }

    private void validate(ModuleSet moduleSet, AssemblerConfigurationSource configSource) {
        List<MavenProject> projects;
        if (moduleSet.getSources() == null && moduleSet.getBinaries() == null) {
            this.getLogger().warn("Encountered ModuleSet with no sources or binaries specified. Skipping.");
        }
        if (moduleSet.isUseAllReactorProjects() && !moduleSet.isIncludeSubModules()) {
            this.getLogger().warn("includeSubModules == false is incompatible with useAllReactorProjects. Ignoring.\n\nTo refactor, remove the <includeSubModules/> flag, and use the <includes/> and <excludes/> sections to fine-tune the modules included.");
        }
        if ((projects = configSource.getReactorProjects()) != null && projects.size() > 1 && projects.indexOf(configSource.getProject()) == 0 && moduleSet.getBinaries() != null) {
            this.getLogger().warn("[DEPRECATION] moduleSet/binaries section detected in root-project assembly.\n\nMODULE BINARIES MAY NOT BE AVAILABLE FOR THIS ASSEMBLY!\n\n To refactor, move this assembly into a child project and use the flag <useAllReactorProjects>true</useAllReactorProjects> in each moduleSet.");
        }
        if (moduleSet.getSources() != null) {
            ModuleSources sources = moduleSet.getSources();
            if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
                this.getLogger().warn("[DEPRECATION] Use of <moduleSources/> as a file-set is deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            } else if (!sources.isUseDefaultExcludes()) {
                this.getLogger().warn("[DEPRECATION] Use of directoryMode, fileMode, or useDefaultExcludes elements directly within <moduleSources/> are all deprecated. Please use the <fileSets/> sub-element of <moduleSources/> instead.");
            }
        }
    }

    protected void addModuleBinaries(ModuleBinaries binaries, Set<MavenProject> projects, Archiver archiver, AssemblerConfigurationSource configSource, AssemblyContext context) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (binaries == null) {
            return;
        }
        LinkedHashSet<MavenProject> moduleProjects = new LinkedHashSet<MavenProject>(projects);
        Iterator it = moduleProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            if (!"pom".equals(project.getPackaging())) continue;
            String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            this.getLogger().debug("Excluding POM-packaging module: " + projectId);
            it.remove();
        }
        String classifier = binaries.getAttachmentClassifier();
        HashMap<MavenProject, Artifact> chosenModuleArtifacts = new HashMap<MavenProject, Artifact>();
        for (MavenProject project : moduleProjects) {
            Artifact artifact = null;
            if (classifier == null) {
                this.getLogger().debug("Processing binary artifact for module project: " + project.getId());
                artifact = project.getArtifact();
            } else {
                this.getLogger().debug("Processing binary attachment: " + classifier + " for module project: " + project.getId());
                List attachments = project.getAttachedArtifacts();
                if (attachments != null && !attachments.isEmpty()) {
                    for (Artifact attachment : attachments) {
                        if (!classifier.equals(attachment.getClassifier())) continue;
                        artifact = attachment;
                        break;
                    }
                }
                if (artifact == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find attachment with classifier: " + classifier + " in module project: " + project.getId() + ". Please exclude this module from the module-set.");
                }
            }
            chosenModuleArtifacts.put(project, artifact);
            this.addModuleArtifact(artifact, project, archiver, configSource, binaries);
        }
        List<DependencySet> depSets = ModuleSetAssemblyPhase.getDependencySets(binaries);
        if (depSets != null) {
            for (DependencySet ds : depSets) {
                ds.setUseProjectArtifact(false);
            }
            List<MavenProject> validateModuleVersions = this.validateModuleVersions(moduleProjects);
            if (!validateModuleVersions.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("The current modules seemed to be having different versions.");
                sb.append(LINE_SEPARATOR);
                for (MavenProject mavenProject : validateModuleVersions) {
                    sb.append(" --> ");
                    sb.append(mavenProject.getId());
                    sb.append(LINE_SEPARATOR);
                }
                this.getLogger().warn(sb.toString());
            }
            for (MavenProject moduleProject : moduleProjects) {
                this.getLogger().debug("Processing binary dependencies for module project: " + moduleProject.getId());
                AddDependencySetsTask task = new AddDependencySetsTask(depSets, context.getResolvedArtifacts(), moduleProject, this.projectBuilder, this.archiverManager, this.getLogger());
                task.setModuleProject(moduleProject);
                task.setModuleArtifact((Artifact)chosenModuleArtifacts.get(moduleProject));
                task.setDefaultOutputDirectory(binaries.getOutputDirectory());
                task.setDefaultOutputFileNameMapping(binaries.getOutputFileNameMapping());
                task.execute(archiver, configSource);
            }
        }
    }

    private List<MavenProject> validateModuleVersions(Set<MavenProject> moduleProjects) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        if (moduleProjects != null && !moduleProjects.isEmpty()) {
            String version = moduleProjects.iterator().next().getVersion();
            this.getLogger().debug("First version:" + version);
            for (MavenProject mavenProject : moduleProjects) {
                this.getLogger().debug(" -> checking " + mavenProject.getId());
                if (version.equals(mavenProject.getVersion())) continue;
                result.add(mavenProject);
            }
        }
        return result;
    }

    public static List<DependencySet> getDependencySets(ModuleBinaries binaries) {
        List<DependencySet> depSets = binaries.getDependencySets();
        if ((depSets == null || depSets.isEmpty()) && binaries.isIncludeDependencies()) {
            DependencySet impliedDependencySet = new DependencySet();
            impliedDependencySet.setOutputDirectory(binaries.getOutputDirectory());
            impliedDependencySet.setOutputFileNameMapping(binaries.getOutputFileNameMapping());
            impliedDependencySet.setFileMode(binaries.getFileMode());
            impliedDependencySet.setDirectoryMode(binaries.getDirectoryMode());
            impliedDependencySet.setExcludes(binaries.getExcludes());
            impliedDependencySet.setIncludes(binaries.getIncludes());
            impliedDependencySet.setUnpack(binaries.isUnpack());
            depSets = Collections.singletonList(impliedDependencySet);
        }
        return depSets;
    }

    protected void addModuleArtifact(Artifact artifact, MavenProject project, Archiver archiver, AssemblerConfigurationSource configSource, ModuleBinaries binaries) throws ArchiveCreationException, AssemblyFormattingException {
        int fileMode;
        if (artifact.getFile() == null) {
            throw new ArchiveCreationException("Artifact: " + artifact.getId() + " (included by module) does not have an artifact with a file. " + "Please ensure the package phase is run before the assembly is generated.");
        }
        AddArtifactTask task = new AddArtifactTask(artifact, this.getLogger());
        task.setFileNameMapping(binaries.getOutputFileNameMapping());
        task.setOutputDirectory(binaries.getOutputDirectory());
        task.setProject(project);
        task.setModuleProject(project);
        task.setModuleArtifact(artifact);
        int dirMode = TypeConversionUtils.modeToInt(binaries.getDirectoryMode(), this.getLogger());
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(binaries.getFileMode(), this.getLogger())) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(binaries.isUnpack());
        if (binaries.isUnpack() && binaries.getUnpackOptions() != null) {
            task.setIncludes(binaries.getUnpackOptions().getIncludes());
            task.setExcludes(binaries.getUnpackOptions().getExcludes());
        }
        task.execute(archiver, configSource);
    }

    protected void addModuleSourceFileSets(ModuleSources sources, Set<MavenProject> moduleProjects, Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        List<FileSet> subFileSets;
        if (sources == null) {
            return;
        }
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        if (this.isDeprecatedModuleSourcesConfigPresent(sources)) {
            FileSet fs = new FileSet();
            fs.setOutputDirectory(sources.getOutputDirectory());
            fs.setIncludes(sources.getIncludes());
            fs.setExcludes(sources.getExcludes());
            fs.setUseDefaultExcludes(sources.isUseDefaultExcludes());
            fileSets.add(fs);
        }
        if ((subFileSets = sources.getFileSets()) == null || subFileSets.isEmpty()) {
            FileSet fs = new FileSet();
            fs.setDirectory("src");
            subFileSets = Collections.singletonList(fs);
        }
        fileSets.addAll(subFileSets);
        for (MavenProject moduleProject : moduleProjects) {
            this.getLogger().info("Processing sources for module project: " + moduleProject.getId());
            ArrayList<FileSet> moduleFileSets = new ArrayList<FileSet>();
            for (FileSet fileSet : fileSets) {
                moduleFileSets.add(this.createFileSet(fileSet, sources, moduleProject, configSource));
            }
            AddFileSetsTask task = new AddFileSetsTask(moduleFileSets);
            task.setProject(moduleProject);
            task.setModuleProject(moduleProject);
            task.setLogger(this.getLogger());
            task.execute(archiver, configSource);
        }
    }

    protected boolean isDeprecatedModuleSourcesConfigPresent(ModuleSources sources) {
        boolean result = false;
        if (sources.getOutputDirectory() != null) {
            result = true;
        } else if (sources.getIncludes() != null && !sources.getIncludes().isEmpty()) {
            result = true;
        } else if (sources.getExcludes() != null && !sources.getExcludes().isEmpty()) {
            result = true;
        }
        return result;
    }

    protected FileSet createFileSet(FileSet fileSet, ModuleSources sources, MavenProject moduleProject, AssemblerConfigurationSource configSource) throws AssemblyFormattingException {
        String destPath;
        FileSet fs = new FileSet();
        String sourcePath = fileSet.getDirectory();
        File moduleBasedir = moduleProject.getBasedir();
        if (sourcePath != null) {
            File sourceDir = new File(sourcePath);
            if (!sourceDir.isAbsolute()) {
                sourcePath = new File(moduleBasedir, sourcePath).getAbsolutePath();
            }
        } else {
            sourcePath = moduleBasedir.getAbsolutePath();
        }
        fs.setDirectory(sourcePath);
        fs.setDirectoryMode(fileSet.getDirectoryMode());
        ArrayList<String> excludes = new ArrayList<String>();
        List<String> originalExcludes = fileSet.getExcludes();
        if (originalExcludes != null && !originalExcludes.isEmpty()) {
            excludes.addAll(originalExcludes);
        }
        if (sources.isExcludeSubModuleDirectories()) {
            List modules = moduleProject.getModules();
            for (String moduleSubPath : modules) {
                excludes.add(moduleSubPath + "/**");
            }
        }
        fs.setExcludes(excludes);
        fs.setFiltered(fileSet.isFiltered());
        fs.setFileMode(fileSet.getFileMode());
        fs.setIncludes(fileSet.getIncludes());
        fs.setLineEnding(fileSet.getLineEnding());
        String destPathPrefix = "";
        if (sources.isIncludeModuleDirectory() && !(destPathPrefix = AssemblyFormatUtils.evaluateFileNameMapping(sources.getOutputDirectoryMapping(), moduleProject.getArtifact(), configSource.getProject(), moduleProject, moduleProject.getArtifact(), moduleProject, configSource)).endsWith("/")) {
            destPathPrefix = destPathPrefix + "/";
        }
        destPath = (destPath = fileSet.getOutputDirectory()) == null ? destPathPrefix : destPathPrefix + destPath;
        destPath = AssemblyFormatUtils.getOutputDirectory(destPath, configSource.getProject(), moduleProject, moduleProject, configSource.getFinalName(), configSource);
        fs.setOutputDirectory(destPath);
        this.getLogger().debug("module source directory is: " + sourcePath);
        this.getLogger().debug("module dest directory is: " + destPath + " (assembly basedir may be prepended)");
        return fs;
    }

    public static Set<MavenProject> getModuleProjects(ModuleSet moduleSet, AssemblerConfigurationSource configSource, Logger logger) throws ArchiveCreationException {
        MavenProject project = configSource.getProject();
        Set<MavenProject> moduleProjects = null;
        if (moduleSet.isUseAllReactorProjects()) {
            if (!moduleSet.isIncludeSubModules()) {
                moduleProjects = new LinkedHashSet<MavenProject>(configSource.getReactorProjects());
            }
            project = configSource.getReactorProjects().get(0);
        }
        if (moduleProjects == null) {
            try {
                moduleProjects = ProjectUtils.getProjectModules(project, configSource.getReactorProjects(), moduleSet.isIncludeSubModules(), logger);
            }
            catch (IOException e) {
                throw new ArchiveCreationException("Error retrieving module-set for project: " + project.getId() + ": " + e.getMessage(), e);
            }
        }
        FilterUtils.filterProjects(moduleProjects, moduleSet.getIncludes(), moduleSet.getExcludes(), true, logger);
        return moduleProjects;
    }
}

