/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.acr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-acr-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven ACR Plugin", 0);
        this.append(sb, "Generates a J2EE Application Client file.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "acr".equals(this.goal)) {
            this.append(sb, "acr:acr", 0);
            this.append(sb, "Build a JavaEE Application Client jar file from the current project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeBackslashesInFilePath (Default: false)", 2);
                this.append(sb, "To escape interpolated value with windows path. c:\\foo\\bar will be replaced with c:\\\\foo\\\\bar.", 3);
                this.append(sb, "Expression: ${acr.escapeBackslashesInFilePath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString", 2);
                this.append(sb, "An expression preceded with this String won't be interpolated. \\${foo} will be replaced with ${foo}.", 3);
                this.append(sb, "Expression: ${acr.escapeString}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The files and directories to exclude from the main Application Client jar. Usage:\n\n<excludes>\n\u00a0\u00a0<exclude>**/*DevOnly.class</exclude>\n</excludes>\n\nDefault exclusions: META-INF/application-client.xml,", 3);
                this.append(sb, "", 0);
                this.append(sb, "filterDeploymentDescriptor (Default: false)", 2);
                this.append(sb, "To filter the deployment descriptor.", 3);
                this.append(sb, "Expression: ${acr.filterDeploymentDescriptor}", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Filters (properties files) to include during the interpolation of the deployment descriptor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jarName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the Application client JAR file to generate.", 3);
                this.append(sb, "Expression: ${jarName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory that resources are copied to during the build.", 3);
                this.append(sb, "Expression: ${outputDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "acr:help", 0);
            this.append(sb, "Display help information on maven-acr-plugin.\nCall\n\u00a0\u00a0mvn\u00a0acr:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

