/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.acr;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class AcrMojo
extends AbstractMojo {
    private static final String APP_CLIENT_XML = "META-INF/application-client.xml";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private static final String[] DEFAULT_EXCLUDES = new String[]{"META-INF/application-client.xml"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private File basedir;
    private File outputDirectory;
    private String jarName;
    private List excludes;
    private MavenProject project;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private boolean escapeBackslashesInFilePath;
    protected String escapeString;
    private boolean filterDeploymentDescriptor;
    private List filters;
    private MavenFileFilter mavenFileFilter;
    private MavenSession session;

    public void execute() throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Building JavaEE Application client: " + this.jarName));
        }
        File jarFile = AcrMojo.getAppClientJarFile(this.basedir, this.jarName);
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        File deploymentDescriptor = new File(this.outputDirectory, APP_CLIENT_XML);
        try {
            String[] mainJarExcludes = DEFAULT_EXCLUDES;
            if (this.excludes != null && !this.excludes.isEmpty()) {
                this.excludes.add(APP_CLIENT_XML);
                mainJarExcludes = this.excludes.toArray(EMPTY_STRING_ARRAY);
            }
            if (!this.outputDirectory.exists()) {
                this.getLog().info((CharSequence)"JAR will only contain the META-INF/application-client.xml as no content was marked for inclusion");
            } else {
                archiver.getArchiver().addDirectory(this.outputDirectory, DEFAULT_INCLUDES, mainJarExcludes);
            }
            if (deploymentDescriptor.exists()) {
                if (this.filterDeploymentDescriptor) {
                    this.getLog().debug((CharSequence)"Filtering deployment descriptor.");
                    MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                    mavenResourcesExecution.setEscapeString(this.escapeString);
                    List filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers(this.project, this.filters, this.escapeBackslashesInFilePath, this.session, mavenResourcesExecution);
                    File unfilteredDeploymentDescriptor = new File(this.outputDirectory, "META-INF/application-client.xml.unfiltered");
                    FileUtils.copyFile((File)deploymentDescriptor, (File)unfilteredDeploymentDescriptor);
                    this.mavenFileFilter.copyFile(unfilteredDeploymentDescriptor, deploymentDescriptor, true, filterWrappers, this.getEncoding(unfilteredDeploymentDescriptor));
                    FileUtils.forceDelete((File)unfilteredDeploymentDescriptor);
                }
                archiver.getArchiver().addFile(deploymentDescriptor, APP_CLIENT_XML);
            }
            archiver.createArchive(this.project, this.archive);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("There was a problem creating the JavaEE Application Client  archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("There was a problem reading / creating the manifest for the JavaEE Application Client  archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("There was a I/O problem creating the JavaEE Application Client archive: " + e.getMessage(), (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("There was a problem resolving dependencies while creating the JavaEE Application Client archive: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("There was a problem filtering the deployment descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
        this.project.getArtifact().setFile(jarFile);
    }

    private static File getAppClientJarFile(File basedir, String finalName) {
        return new File(basedir, finalName + ".jar");
    }

    private String getEncoding(File xmlFile) throws IOException {
        XmlStreamReader xmlReader = new XmlStreamReader(xmlFile);
        return xmlReader.getEncoding();
    }
}

