/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import org.apache.maven.jxr.DirectoryIndexer;
import org.apache.maven.jxr.JavaCodeTransform;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.ant.DirectoryScanner;
import org.apache.maven.jxr.pacman.PackageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JXR {
    private static final Logger LOGGER = LoggerFactory.getLogger(JXR.class);
    private final PackageManager pkgmgr;
    private final JavaCodeTransform transformer;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java"};
    private Path destDir;
    private Locale locale;
    private String inputEncoding;
    private String outputEncoding;
    private Path javadocLinkDir;
    private String revision;
    private String[] excludes = null;
    private String[] includes = DEFAULT_INCLUDES;

    public JXR(PackageManager pkgmgr, JavaCodeTransform transformer) {
        this.pkgmgr = pkgmgr;
        this.transformer = transformer;
    }

    public void processPath(PackageManager packageManager, Path sourceDir, String bottom) throws IOException {
        String[] files;
        DirectoryScanner ds = new DirectoryScanner();
        ds.setExcludes(this.excludes);
        ds.setIncludes(this.includes);
        ds.addDefaultExcludes();
        ds.setBasedir(sourceDir.toString());
        ds.scan();
        for (String file : files = ds.getIncludedFiles()) {
            Path sourceFile = sourceDir.resolve(file);
            if (!JXR.isJavaFile(sourceFile.toString())) continue;
            String newFileName = file.replaceFirst(".java$", ".html");
            this.transform(sourceFile, this.destDir.resolve(newFileName), bottom);
        }
    }

    public static boolean isJavaFile(String filename) {
        return filename.endsWith(".java");
    }

    public static boolean isHtmlFile(String filename) {
        return filename.endsWith(".html");
    }

    public void setDest(Path dest) {
        this.destDir = dest;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setJavadocLinkDir(Path javadocLinkDir) {
        this.javadocLinkDir = javadocLinkDir;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void xref(List<String> sourceDirs, String templateDir, String windowTitle, String docTitle, String bottom) throws IOException, JxrException {
        this.pkgmgr.setExcludes(this.excludes);
        this.pkgmgr.setIncludes(this.includes);
        for (String dir : sourceDirs) {
            Path path = Paths.get(dir, new String[0]).toRealPath(new LinkOption[0]);
            this.pkgmgr.process(path);
            this.processPath(this.pkgmgr, path, bottom);
        }
        DirectoryIndexer indexer = new DirectoryIndexer(this.pkgmgr, this.destDir.toString());
        indexer.setOutputEncoding(this.outputEncoding);
        indexer.setTemplateDir(templateDir);
        indexer.setWindowTitle(windowTitle);
        indexer.setDocTitle(docTitle);
        indexer.setBottom(bottom);
        indexer.process();
    }

    private void transform(Path sourceFile, Path destFile, String bottom) throws IOException {
        LOGGER.debug(sourceFile + " -> " + destFile);
        Path javadoc = this.javadocLinkDir != null ? JXR.getRelativeLink(destFile.getParent(), this.javadocLinkDir) : null;
        this.transformer.transform(sourceFile, destFile, this.locale, this.inputEncoding, this.outputEncoding, javadoc, this.revision, bottom);
    }

    private static Path getRelativeLink(Path fromDir, Path toDir) {
        return fromDir.relativize(toDir);
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes == null ? DEFAULT_INCLUDES : includes;
    }
}

