/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.maven.jxr.DirectoryIndexer;
import org.apache.maven.jxr.JavaCodeTransform;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.ant.DirectoryScanner;
import org.apache.maven.jxr.log.Log;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.PackageManager;

public class JXR {
    private Log log;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java"};
    private String dest = "";
    private Locale locale;
    private String inputEncoding;
    private String outputEncoding;
    private String javadocLinkDir;
    private JavaCodeTransform transformer;
    private String revision;
    private String[] excludes = null;
    private String[] includes = DEFAULT_INCLUDES;

    public void processPath(PackageManager packageManager, String source, String bottom) throws IOException {
        this.transformer = new JavaCodeTransform(packageManager);
        DirectoryScanner ds = new DirectoryScanner();
        ds.setExcludes(this.excludes);
        ds.setIncludes(this.includes);
        ds.addDefaultExcludes();
        File dir = new File(source);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Your source directory does not exist and could not be created:" + source);
        }
        ds.setBasedir(source);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            String src = source + System.getProperty("file.separator") + files[i];
            if (!JXR.isJavaFile(src)) continue;
            this.transform(src, this.getDestination(source, src), bottom);
        }
    }

    public static boolean isJavaFile(String filename) {
        File file = new File(filename);
        return filename.endsWith(".java") && file.length() > 0L;
    }

    public static boolean isHtmlFile(String filename) {
        return filename.endsWith(".html");
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setJavadocLinkDir(String javadocLinkDir) {
        this.javadocLinkDir = javadocLinkDir;
    }

    public void setTransformer(JavaCodeTransform transformer) {
        this.transformer = transformer;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void xref(List sourceDirs, String templateDir, String windowTitle, String docTitle, String bottom) throws IOException, JxrException {
        FileManager fileManager = new FileManager();
        fileManager.setEncoding(this.inputEncoding);
        PackageManager pkgmgr = new PackageManager(this.log, fileManager);
        pkgmgr.setExcludes(this.excludes);
        pkgmgr.setIncludes(this.includes);
        for (String path : sourceDirs) {
            path = new File(path).getCanonicalPath();
            pkgmgr.process(path);
            this.processPath(pkgmgr, path, bottom);
        }
        DirectoryIndexer indexer = new DirectoryIndexer(pkgmgr, this.dest);
        indexer.setOutputEncoding(this.outputEncoding);
        indexer.setTemplateDir(templateDir);
        indexer.setWindowTitle(windowTitle);
        indexer.setDocTitle(docTitle);
        indexer.setBottom(bottom);
        indexer.process(this.log);
    }

    private String getDestination(String source, String filename) {
        String dest = filename.substring(source.length(), filename.length());
        int start = 0;
        int end = dest.indexOf(".java");
        if (end != -1) {
            dest = dest.substring(start, end);
        }
        dest = this.getDest() + dest;
        dest = dest + ".html";
        return dest;
    }

    private void transform(String source, String dest, String bottom) throws IOException {
        this.log.debug(source + " -> " + dest);
        String javadoc = this.javadocLinkDir != null ? JXR.getRelativeLink(dest, this.javadocLinkDir) : null;
        this.transformer.transform(source, dest, this.locale, this.inputEncoding, this.outputEncoding, javadoc, this.revision, bottom);
    }

    private static String getRelativeLink(String fromDir, String toDir) throws IOException {
        StringBuffer toLink = new StringBuffer();
        StringBuffer fromLink = new StringBuffer();
        LinkedList<File> parents = new LinkedList<File>();
        File f = new File(toDir);
        for (f = f.getCanonicalFile(); f != null; f = f.getParentFile()) {
            parents.add(f);
        }
        f = new File(fromDir);
        if (!f.isDirectory()) {
            f = f.getParentFile();
        }
        f = f.getCanonicalFile();
        boolean found = false;
        for (f = f.getParentFile(); f != null && !found; f = f.getParentFile()) {
            for (int i = 0; i < parents.size(); ++i) {
                File parent = (File)parents.get(i);
                if (!f.equals(parent)) continue;
                for (int j = 0; j < i; ++j) {
                    File p = (File)parents.get(j);
                    toLink.insert(0, p.getName() + "/");
                }
                found = true;
                break;
            }
            fromLink.append("../");
        }
        if (!found) {
            throw new FileNotFoundException(fromDir + " and " + toDir + " have no common parent.");
        }
        return fromLink.append(toLink.toString()).toString();
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes == null ? DEFAULT_INCLUDES : includes;
    }
}

