/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xdoc;

import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.xdoc.XdocMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.SinkUtils;
import org.apache.maven.doxia.sink.XhtmlBaseSink;
import org.apache.maven.doxia.util.HtmlTools;

public class XdocSink
extends XhtmlBaseSink
implements XdocMarkup {
    private boolean boxedFlag;
    private String encoding;
    private String languageId;

    protected XdocSink(Writer writer) {
        super(writer);
    }

    protected XdocSink(Writer writer, String encoding) {
        this(writer);
        this.encoding = encoding;
    }

    protected XdocSink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.languageId = languageId;
    }

    protected void resetState() {
        super.resetState();
        this.boxedFlag = false;
    }

    public void head() {
        this.resetState();
        this.setHeadFlag(true);
        this.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.write(" encoding=\"" + this.encoding + "\"");
        }
        this.write("?>");
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns", "http://maven.apache.org/XDOC/2.0");
        atts.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        atts.addAttribute("xsi:schemaLocation", "http://maven.apache.org/XDOC/2.0 http://maven.apache.org/xsd/xdoc-2.0.xsd");
        if (this.languageId != null) {
            atts.addAttribute(HTML.Attribute.LANG.toString(), this.languageId);
            atts.addAttribute("xml:lang", this.languageId);
        }
        this.writeStartTag(DOCUMENT_TAG, (MutableAttributeSet)atts);
        this.writeStartTag(PROPERTIES_TAG);
    }

    public void head_() {
        this.setHeadFlag(false);
        this.writeEndTag(PROPERTIES_TAG);
    }

    public void title() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void title_() {
        this.content(this.getTextBuffer().toString());
        this.writeEndTag(HTML.Tag.TITLE);
        this.resetTextBuffer();
    }

    public void author_() {
        if (this.getTextBuffer().length() > 0) {
            this.writeStartTag(AUTHOR_TAG);
            this.content(this.getTextBuffer().toString());
            this.writeEndTag(AUTHOR_TAG);
            this.resetTextBuffer();
        }
    }

    public void date_() {
        if (this.getTextBuffer().length() > 0) {
            this.writeStartTag(DATE_TAG);
            this.content(this.getTextBuffer().toString());
            this.writeEndTag(DATE_TAG);
            this.resetTextBuffer();
        }
    }

    public void body() {
        this.writeStartTag(HTML.Tag.BODY);
    }

    public void body_() {
        this.writeEndTag(HTML.Tag.BODY);
        this.writeEndTag(DOCUMENT_TAG);
        this.flush();
        this.resetState();
    }

    protected void onSection(int depth, SinkEventAttributes attributes) {
        if (depth == 1) {
            this.write(String.valueOf('<') + SECTION_TAG.toString() + String.valueOf(' ') + HTML.Attribute.NAME + String.valueOf('=') + String.valueOf('\"') + SinkUtils.getAttributeString((AttributeSet)SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_BASE_ATTRIBUTES)));
        } else if (depth == 2) {
            this.write(String.valueOf('<') + SUBSECTION_TAG.toString() + String.valueOf(' ') + HTML.Attribute.NAME + String.valueOf('=') + String.valueOf('\"') + SinkUtils.getAttributeString((AttributeSet)SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_BASE_ATTRIBUTES)));
        }
    }

    protected void onSection_(int depth) {
        if (depth == 1) {
            this.writeEndTag(SECTION_TAG);
        } else if (depth == 2) {
            this.writeEndTag(SUBSECTION_TAG);
        }
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_SECTION_ATTRIBUTES);
        if (depth == 3) {
            this.writeStartTag(HTML.Tag.H4, atts);
        } else if (depth == 4) {
            this.writeStartTag(HTML.Tag.H5, atts);
        } else if (depth == 5) {
            this.writeStartTag(HTML.Tag.H6, atts);
        }
    }

    protected void onSectionTitle_(int depth) {
        if (depth == 1 || depth == 2) {
            this.write(String.valueOf('\"') + String.valueOf('>'));
        } else if (depth == 3) {
            this.writeEndTag(HTML.Tag.H4);
        } else if (depth == 4) {
            this.writeEndTag(HTML.Tag.H5);
        } else if (depth == 5) {
            this.writeEndTag(HTML.Tag.H6);
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.setVerbatimFlag(true);
        MutableAttributeSet atts = SinkUtils.filterAttributes((AttributeSet)attributes, (String[])SinkUtils.SINK_VERBATIM_ATTRIBUTES);
        if (atts == null) {
            atts = new SinkEventAttributeSet();
        }
        boolean boxed = false;
        if (atts.isDefined("decoration")) {
            boxed = "boxed".equals((String)atts.getAttribute("decoration"));
        }
        this.boxedFlag = boxed;
        atts.removeAttribute("decoration");
        if (boxed) {
            this.writeStartTag(SOURCE_TAG, atts);
        } else {
            atts.removeAttribute(HTML.Attribute.ALIGN.toString());
            this.writeStartTag(HTML.Tag.PRE, atts);
        }
    }

    public void verbatim_() {
        if (this.boxedFlag) {
            this.writeEndTag(SOURCE_TAG);
        } else {
            this.writeEndTag(HTML.Tag.PRE);
        }
        this.setVerbatimFlag(false);
        this.boxedFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.setCellJustif(justification);
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.ALIGN, "center");
        att.addAttribute(HTML.Attribute.BORDER, grid ? "1" : "0");
        this.writeStartTag(HTML.Tag.TABLE, (MutableAttributeSet)att);
    }

    public void tableRow() {
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        att.addAttribute(HTML.Attribute.VALIGN, "top");
        this.writeStartTag(HTML.Tag.TR, (MutableAttributeSet)att);
        this.setCellCount(0);
    }

    public void link(String name, String target) {
        if (this.isHeadFlag()) {
            return;
        }
        SinkEventAttributeSet att = new SinkEventAttributeSet();
        if (target != null) {
            att.addAttribute(HTML.Attribute.TARGET, target);
        }
        att.addAttribute(HTML.Attribute.HREF, HtmlTools.escapeHTML((String)name));
        this.writeStartTag(HTML.Tag.A, (MutableAttributeSet)att);
    }

    protected void markup(String text) {
        this.write(text);
    }
}

