/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.markdown.MarkdownToDoxiaHtmlSerializer;
import org.apache.maven.doxia.module.xhtml.XhtmlParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.HeaderNode;
import org.pegdown.ast.HtmlBlockNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.ast.TextNode;

@Component(role=Parser.class, hint="markdown")
public class MarkdownParser
extends XhtmlParser {
    public static final String ROLE_HINT = "markdown";
    protected static final PegDownProcessor PEGDOWN_PROCESSOR = new PegDownProcessor(65527, Long.MAX_VALUE);
    private static final String MULTI_MARKDOWN_METADATA_SECTION = "^(((?:[^\\s:][^:]*):(?:.*(?:\r?\n\\p{Blank}+[^\\s].*)*\r?\n))+)(?:\\s*\r?\n)";
    private static final String MULTI_MARKDOWN_METADATA_ENTRY = "([^\\s:][^:]*):(.*(?:\r?\n\\p{Blank}+[^\\s].*)*)\r?\n";
    private static final String[] STANDARD_METADATA_KEYS = new String[]{"title", "author", "date", "address", "affiliation", "copyright", "email", "keywords", "language", "phone", "subtitle"};

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            String text = IOUtil.toString((Reader)source);
            StringBuilder html = new StringBuilder(text.length() * 2);
            html.append("<html>");
            html.append("<head>");
            Pattern metadataPattern = Pattern.compile(MULTI_MARKDOWN_METADATA_SECTION, 8);
            Matcher metadataMatcher = metadataPattern.matcher(text);
            boolean haveTitle = false;
            if (metadataMatcher.find()) {
                metadataPattern = Pattern.compile(MULTI_MARKDOWN_METADATA_ENTRY, 8);
                Matcher lineMatcher = metadataPattern.matcher(metadataMatcher.group(1));
                boolean first = true;
                while (lineMatcher.find()) {
                    String key = StringUtils.trimToEmpty((String)lineMatcher.group(1));
                    if (first) {
                        boolean found = false;
                        for (String k : STANDARD_METADATA_KEYS) {
                            if (!k.equalsIgnoreCase(key)) continue;
                            found = true;
                            break;
                        }
                        if (!found) break;
                        first = false;
                    }
                    String value = StringUtils.trimToEmpty((String)lineMatcher.group(2));
                    if ("title".equalsIgnoreCase(key)) {
                        haveTitle = true;
                        html.append("<title>");
                        html.append(StringEscapeUtils.escapeXml((String)value));
                        html.append("</title>");
                        continue;
                    }
                    if ("author".equalsIgnoreCase(key)) {
                        html.append("<meta name='author' content='");
                        html.append(StringEscapeUtils.escapeXml((String)value));
                        html.append("' />");
                        continue;
                    }
                    if ("date".equalsIgnoreCase(key)) {
                        html.append("<meta name='date' content='");
                        html.append(StringEscapeUtils.escapeXml((String)value));
                        html.append("' />");
                        continue;
                    }
                    html.append("<meta name='");
                    html.append(StringEscapeUtils.escapeXml((String)key));
                    html.append("' content='");
                    html.append(StringEscapeUtils.escapeXml((String)value));
                    html.append("' />");
                }
                if (!first) {
                    text = text.substring(metadataMatcher.end());
                }
            }
            RootNode rootNode = PEGDOWN_PROCESSOR.parseMarkdown(text.toCharArray());
            if (!haveTitle && rootNode.getChildren().size() > 0) {
                Node firstNode = null;
                for (int i = 0; i < rootNode.getChildren().size() && MarkdownParser.isHtmlComment(firstNode = (Node)rootNode.getChildren().get(i)); ++i) {
                }
                if (firstNode instanceof HeaderNode) {
                    html.append("<title>");
                    html.append(StringEscapeUtils.escapeXml((String)MarkdownParser.nodeText(firstNode)));
                    html.append("</title>");
                }
            }
            html.append("</head>");
            html.append("<body>");
            html.append(new MarkdownToDoxiaHtmlSerializer().toHtml(rootNode));
            html.append("</body>");
            html.append("</html>");
            super.parse((Reader)new StringReader(html.toString()), sink);
        }
        catch (IOException e) {
            throw new ParseException("Failed reading Markdown source document", (Exception)e);
        }
    }

    public static boolean isHtmlComment(Node node) {
        if (node instanceof HtmlBlockNode) {
            HtmlBlockNode blockNode = (HtmlBlockNode)node;
            return blockNode.getText().startsWith("<!--");
        }
        return false;
    }

    public static String nodeText(Node node) {
        StringBuilder builder = new StringBuilder();
        if (node instanceof TextNode) {
            builder.append(((TextNode)TextNode.class.cast(node)).getText());
        } else {
            for (Node n : node.getChildren()) {
                if (n instanceof TextNode) {
                    builder.append(((TextNode)TextNode.class.cast(n)).getText());
                    continue;
                }
                if (!(n instanceof SuperNode)) continue;
                builder.append(MarkdownParser.nodeText(n));
            }
        }
        return builder.toString();
    }

    protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
        boolean visited = super.baseEndTag(parser, sink);
        if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
            this.handleUnknown(parser, sink, 3);
            visited = true;
        }
        return visited;
    }

    protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
        boolean visited = super.baseStartTag(parser, sink);
        if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
            this.handleUnknown(parser, sink, 2);
            visited = true;
        }
        return visited;
    }
}

