/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser.builders;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.xmlparser.DOMUtils;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.builders.SpanBuilderBase;
import org.w3c.dom.Element;

public class SpanOrTermsBuilder
extends SpanBuilderBase {
    Analyzer analyzer;

    public SpanOrTermsBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public SpanQuery getSpanQuery(Element e) throws ParserException {
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        String value = DOMUtils.getNonBlankTextOrFail(e);
        try {
            ArrayList<SpanTermQuery> clausesList = new ArrayList<SpanTermQuery>();
            TokenStream ts = this.analyzer.reusableTokenStream(fieldName, (Reader)new StringReader(value));
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            ts.reset();
            while (ts.incrementToken()) {
                SpanTermQuery stq = new SpanTermQuery(new Term(fieldName, termAtt.toString()));
                clausesList.add(stq);
            }
            ts.end();
            ts.close();
            SpanOrQuery soq = new SpanOrQuery(clausesList.toArray(new SpanQuery[clausesList.size()]));
            soq.setBoost(DOMUtils.getAttribute(e, "boost", 1.0f));
            return soq;
        }
        catch (IOException ioe) {
            throw new ParserException("IOException parsing value:" + value);
        }
    }
}

