/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopGroups<GROUP_VALUE_TYPE> {
    public final int totalHitCount;
    public final int totalGroupedHitCount;
    public final Integer totalGroupCount;
    public final GroupDocs<GROUP_VALUE_TYPE>[] groups;
    public final SortField[] groupSort;
    public final SortField[] withinGroupSort;

    public TopGroups(SortField[] groupSort, SortField[] withinGroupSort, int totalHitCount, int totalGroupedHitCount, GroupDocs<GROUP_VALUE_TYPE>[] groups) {
        this.groupSort = groupSort;
        this.withinGroupSort = withinGroupSort;
        this.totalHitCount = totalHitCount;
        this.totalGroupedHitCount = totalGroupedHitCount;
        this.groups = groups;
        this.totalGroupCount = null;
    }

    public TopGroups(TopGroups<GROUP_VALUE_TYPE> oldTopGroups, Integer totalGroupCount) {
        this.groupSort = oldTopGroups.groupSort;
        this.withinGroupSort = oldTopGroups.withinGroupSort;
        this.totalHitCount = oldTopGroups.totalHitCount;
        this.totalGroupedHitCount = oldTopGroups.totalGroupedHitCount;
        this.groups = oldTopGroups.groups;
        this.totalGroupCount = totalGroupCount;
    }

    public static <T> TopGroups<T> merge(TopGroups<T>[] shardGroups, Sort groupSort, Sort docSort, int docOffset, int docTopN) throws IOException {
        if (shardGroups.length == 0) {
            return null;
        }
        int totalHitCount = 0;
        int totalGroupedHitCount = 0;
        int numGroups = shardGroups[0].groups.length;
        for (TopGroups<T> shard : shardGroups) {
            if (numGroups != shard.groups.length) {
                throw new IllegalArgumentException("number of groups differs across shards; you must pass same top groups to all shards' second-pass collector");
            }
            totalHitCount += shard.totalHitCount;
            totalGroupedHitCount += shard.totalGroupedHitCount;
        }
        GroupDocs[] mergedGroupDocs = new GroupDocs[numGroups];
        TopDocs[] shardTopDocs = new TopDocs[shardGroups.length];
        for (int groupIDX = 0; groupIDX < numGroups; ++groupIDX) {
            ScoreDoc[] mergedScoreDocs;
            Object groupValue = shardGroups[0].groups[groupIDX].groupValue;
            float maxScore = Float.MIN_VALUE;
            int totalHits = 0;
            for (int shardIDX = 0; shardIDX < shardGroups.length; ++shardIDX) {
                TopGroups<T> shard = shardGroups[shardIDX];
                GroupDocs shardGroupDocs = shard.groups[groupIDX];
                if (groupValue == null ? shardGroupDocs.groupValue != null : !groupValue.equals(shardGroupDocs.groupValue)) {
                    throw new IllegalArgumentException("group values differ across shards; you must pass same top groups to all shards' second-pass collector");
                }
                shardTopDocs[shardIDX] = new TopDocs(shardGroupDocs.totalHits, shardGroupDocs.scoreDocs, shardGroupDocs.maxScore);
                maxScore = Math.max(maxScore, shardGroupDocs.maxScore);
                totalHits += shardGroupDocs.totalHits;
            }
            TopDocs mergedTopDocs = TopDocs.merge((Sort)docSort, (int)(docOffset + docTopN), (TopDocs[])shardTopDocs);
            if (docOffset == 0) {
                mergedScoreDocs = mergedTopDocs.scoreDocs;
            } else if (docOffset >= mergedTopDocs.scoreDocs.length) {
                mergedScoreDocs = new ScoreDoc[]{};
            } else {
                mergedScoreDocs = new ScoreDoc[mergedTopDocs.scoreDocs.length - docOffset];
                System.arraycopy(mergedTopDocs.scoreDocs, docOffset, mergedScoreDocs, 0, mergedTopDocs.scoreDocs.length - docOffset);
            }
            mergedGroupDocs[groupIDX] = new GroupDocs(maxScore, totalHits, mergedScoreDocs, groupValue, shardGroups[0].groups[groupIDX].groupSortValues);
        }
        return new TopGroups(groupSort.getSort(), docSort == null ? null : docSort.getSort(), totalHitCount, totalGroupedHitCount, mergedGroupDocs);
    }
}

