/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;

public class MultiFacetsAccumulator
extends FacetsAccumulator {
    private final FacetsAccumulator[] accumulators;

    public static FacetsAccumulator wrap(FacetsAccumulator ... accumulators) {
        if (accumulators.length == 0) {
            return accumulators[0];
        }
        return new MultiFacetsAccumulator(accumulators);
    }

    private MultiFacetsAccumulator(FacetsAccumulator ... accumulators) {
        super(null);
        this.accumulators = accumulators;
    }

    @Override
    public boolean requiresDocScores() {
        for (FacetsAccumulator fa : this.accumulators) {
            if (!fa.requiresDocScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        ArrayList<FacetResult> merged = new ArrayList<FacetResult>();
        for (FacetsAccumulator fa : this.accumulators) {
            merged.addAll(fa.accumulate(matchingDocs));
        }
        return merged;
    }
}

