/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DrillSidewaysCollector
extends Collector {
    private final Collector hitCollector;
    private final Collector drillDownCollector;
    private final Collector[] drillSidewaysCollectors;
    private final Scorer[] subScorers;
    private final int exactCount;
    private final Map<Weight, Integer> weightToIndex = new IdentityHashMap<Weight, Integer>();
    private Scorer mainScorer;

    public DrillSidewaysCollector(Collector hitCollector, Collector drillDownCollector, Collector[] drillSidewaysCollectors, Map<String, Integer> dims) {
        this.hitCollector = hitCollector;
        this.drillDownCollector = drillDownCollector;
        this.drillSidewaysCollectors = drillSidewaysCollectors;
        this.subScorers = new Scorer[dims.size()];
        this.exactCount = dims.size() == 1 ? 2 : dims.size();
    }

    public void collect(int doc) throws IOException {
        if (this.mainScorer == null) {
            return;
        }
        if (this.mainScorer.freq() == this.exactCount) {
            this.hitCollector.collect(doc);
            if (this.drillDownCollector != null) {
                this.drillDownCollector.collect(doc);
            }
            for (int i = 0; i < this.subScorers.length; ++i) {
                assert (this.subScorers[i] != null);
                int subDoc = this.subScorers[i].docID();
                assert (subDoc == doc);
                this.drillSidewaysCollectors[i].collect(doc);
            }
        } else {
            boolean found = false;
            for (int i = 0; i < this.subScorers.length; ++i) {
                if (this.subScorers[i] == null) {
                    this.drillSidewaysCollectors[i].collect(doc);
                    assert (this.allMatchesFrom(i + 1, doc));
                    found = true;
                    break;
                }
                int subDoc = this.subScorers[i].docID();
                if (subDoc == doc) continue;
                assert (subDoc > doc) : "subDoc=" + subDoc + " doc=" + doc;
                this.drillSidewaysCollectors[i].collect(doc);
                assert (this.allMatchesFrom(i + 1, doc));
                found = true;
                break;
            }
            assert (found);
        }
    }

    private boolean allMatchesFrom(int startFrom, int doc) {
        for (int i = startFrom; i < this.subScorers.length; ++i) {
            assert (this.subScorers[i].docID() == doc);
        }
        return true;
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public void setNextReader(AtomicReaderContext leaf) throws IOException {
        this.hitCollector.setNextReader(leaf);
        if (this.drillDownCollector != null) {
            this.drillDownCollector.setNextReader(leaf);
        }
        for (Collector dsc : this.drillSidewaysCollectors) {
            dsc.setNextReader(leaf);
        }
    }

    void setWeight(Weight weight, int index) {
        assert (!this.weightToIndex.containsKey(weight));
        this.weightToIndex.put(weight, index);
    }

    private void findScorers(Scorer scorer) {
        Integer index = this.weightToIndex.get(scorer.getWeight());
        if (index != null) {
            if (index == -1) {
                this.mainScorer = scorer;
            } else {
                this.subScorers[index.intValue()] = scorer;
            }
        }
        for (Scorer.ChildScorer child : scorer.getChildren()) {
            this.findScorers(child.child);
        }
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.mainScorer = null;
        Arrays.fill(this.subScorers, null);
        this.findScorers(scorer);
        this.hitCollector.setScorer(scorer);
        if (this.drillDownCollector != null) {
            this.drillDownCollector.setScorer(scorer);
        }
        for (Collector dsc : this.drillSidewaysCollectors) {
            dsc.setScorer(scorer);
        }
    }
}

