/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sampling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.old.OldFacetsAccumulator;
import org.apache.lucene.facet.old.ScoredDocIDs;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.partitions.PartitionsFacetResultsHandler;
import org.apache.lucene.facet.sampling.SampleFixer;
import org.apache.lucene.facet.sampling.Sampler;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class SamplingAccumulator
extends OldFacetsAccumulator {
    private double samplingRatio = -1.0;
    private final Sampler sampler;

    public SamplingAccumulator(Sampler sampler, FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, FacetArrays facetArrays) {
        super(searchParams, indexReader, taxonomyReader, facetArrays);
        this.sampler = sampler;
    }

    public SamplingAccumulator(Sampler sampler, FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        super(searchParams, indexReader, taxonomyReader);
        this.sampler = sampler;
    }

    @Override
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        FacetSearchParams original = this.searchParams;
        SampleFixer samplerFixer = this.sampler.samplingParams.getSampleFixer();
        boolean shouldOversample = this.sampler.samplingParams.shouldOverSample();
        if (shouldOversample) {
            this.searchParams = this.sampler.overSampledSearchParams(original);
        }
        List<FacetResult> sampleRes = super.accumulate(docids);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (FacetResult fres : sampleRes) {
            FacetRequest fr = fres.getFacetRequest();
            PartitionsFacetResultsHandler frh = this.createFacetResultsHandler(fr, this.createOrdinalValueResolver(fr));
            if (samplerFixer != null) {
                samplerFixer.fixResult(docids, fres, this.samplingRatio);
                fres = frh.rearrangeFacetResult(fres);
                if (shouldOversample) {
                    fres = this.sampler.trimResult(fres);
                }
            }
            if (fres.getFacetResultNode().ordinal == -1) {
                results.add(SamplingAccumulator.emptyResult(fres.getFacetResultNode().ordinal, fr));
                continue;
            }
            frh.labelResult(fres);
            results.add(fres);
        }
        this.searchParams = original;
        return results;
    }

    @Override
    protected ScoredDocIDs actualDocsToAccumulate(ScoredDocIDs docids) throws IOException {
        Sampler.SampleResult sampleRes = this.sampler.getSampleSet(docids);
        this.samplingRatio = sampleRes.actualSampleRatio;
        return sampleRes.docids;
    }

    @Override
    protected double getTotalCountsFactor() {
        if (this.samplingRatio < 0.0) {
            throw new IllegalStateException("Total counts ratio unavailable because actualDocsToAccumulate() was not invoked");
        }
        return this.samplingRatio;
    }
}

