/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.complements.TotalFacetCounts;
import org.apache.lucene.facet.complements.TotalFacetCountsCache;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.partitions.IntermediateFacetResult;
import org.apache.lucene.facet.partitions.PartitionsFacetResultsHandler;
import org.apache.lucene.facet.search.Aggregator;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetResultNode;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.MatchingDocsAsScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.ScoredDocIDsIterator;
import org.apache.lucene.facet.search.TopKFacetResultsHandler;
import org.apache.lucene.facet.search.TopKInEachNodeHandler;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.facet.util.ScoredDocIdsUtils;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.IntsRef;

public class StandardFacetsAccumulator
extends FacetsAccumulator {
    private static final Logger logger = Logger.getLogger(StandardFacetsAccumulator.class.getName());
    public static final double DEFAULT_COMPLEMENT_THRESHOLD = 0.6;
    public static final double DISABLE_COMPLEMENT = Double.POSITIVE_INFINITY;
    public static final double FORCE_COMPLEMENT = 0.0;
    protected int partitionSize;
    protected int maxPartitions;
    protected boolean isUsingComplements = false;
    private TotalFacetCounts totalFacetCounts;
    private Object accumulateGuard;
    private double complementThreshold;

    public StandardFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this(searchParams, indexReader, taxonomyReader, new FacetArrays(PartitionsUtils.partitionSize(searchParams.indexingParams, taxonomyReader)));
    }

    public StandardFacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader, FacetArrays facetArrays) {
        super(searchParams, indexReader, taxonomyReader, facetArrays);
        this.partitionSize = PartitionsUtils.partitionSize(searchParams.indexingParams, taxonomyReader);
        this.maxPartitions = (int)Math.ceil((double)this.taxonomyReader.getSize() / (double)this.partitionSize);
        this.accumulateGuard = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FacetResult> accumulate(ScoredDocIDs docids) throws IOException {
        Object object = this.accumulateGuard;
        synchronized (object) {
            this.isUsingComplements = this.shouldComplement(docids);
            if (this.isUsingComplements) {
                try {
                    this.totalFacetCounts = TotalFacetCountsCache.getSingleton().getTotalCounts(this.indexReader, this.taxonomyReader, this.searchParams.indexingParams);
                    if (this.totalFacetCounts != null) {
                        docids = ScoredDocIdsUtils.getComplementSet(docids, this.indexReader);
                    } else {
                        this.isUsingComplements = false;
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "IndexReader used does not support completents: ", e);
                    }
                    this.isUsingComplements = false;
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Failed to load/calculate total counts (complement counting disabled): ", e);
                    }
                    this.isUsingComplements = false;
                }
                catch (Exception e) {
                    throw new IOException("PANIC: Got unexpected exception while trying to get/calculate total counts", e);
                }
            }
            docids = this.actualDocsToAccumulate(docids);
            HashMap<FacetRequest, IntermediateFacetResult> fr2tmpRes = new HashMap<FacetRequest, IntermediateFacetResult>();
            try {
                for (int part = 0; part < this.maxPartitions; ++part) {
                    this.fillArraysForPartition(docids, this.facetArrays, part);
                    int offset = part * this.partitionSize;
                    HashSet<FacetRequest> handledRequests = new HashSet<FacetRequest>();
                    for (FacetRequest fr : this.searchParams.facetRequests) {
                        if (!handledRequests.add(fr)) continue;
                        PartitionsFacetResultsHandler frHndlr = this.createFacetResultsHandler(fr);
                        IntermediateFacetResult res4fr = frHndlr.fetchPartitionResult(offset);
                        IntermediateFacetResult oldRes = (IntermediateFacetResult)fr2tmpRes.get(fr);
                        if (oldRes != null) {
                            res4fr = frHndlr.mergeResults(oldRes, res4fr);
                        }
                        fr2tmpRes.put(fr, res4fr);
                    }
                }
            }
            finally {
                this.facetArrays.free();
            }
            ArrayList<FacetResult> res = new ArrayList<FacetResult>();
            for (FacetRequest fr : this.searchParams.facetRequests) {
                PartitionsFacetResultsHandler frHndlr = this.createFacetResultsHandler(fr);
                IntermediateFacetResult tmpResult = (IntermediateFacetResult)fr2tmpRes.get(fr);
                if (tmpResult == null) {
                    FacetResultNode root = new FacetResultNode();
                    root.ordinal = -1;
                    root.label = fr.categoryPath;
                    root.value = 0.0;
                    res.add(new FacetResult(fr, root, 0));
                    continue;
                }
                FacetResult facetRes = frHndlr.renderFacetResult(tmpResult);
                frHndlr.labelResult(facetRes);
                res.add(facetRes);
            }
            return res;
        }
    }

    protected boolean mayComplement() {
        for (FacetRequest freq : this.searchParams.facetRequests) {
            if (freq instanceof CountFacetRequest) continue;
            return false;
        }
        return true;
    }

    @Override
    protected PartitionsFacetResultsHandler createFacetResultsHandler(FacetRequest fr) {
        if (fr.getResultMode() == FacetRequest.ResultMode.PER_NODE_IN_TREE) {
            return new TopKInEachNodeHandler(this.taxonomyReader, fr, this.facetArrays);
        }
        return new TopKFacetResultsHandler(this.taxonomyReader, fr, this.facetArrays);
    }

    protected ScoredDocIDs actualDocsToAccumulate(ScoredDocIDs docids) throws IOException {
        return docids;
    }

    protected boolean shouldComplement(ScoredDocIDs docids) {
        return this.mayComplement() && (double)docids.size() > (double)this.indexReader.numDocs() * this.getComplementThreshold();
    }

    private final void fillArraysForPartition(ScoredDocIDs docids, FacetArrays facetArrays, int partition) throws IOException {
        if (this.isUsingComplements) {
            this.initArraysByTotalCounts(facetArrays, partition, docids.size());
        } else {
            facetArrays.free();
        }
        HashMap<CategoryListIterator, Aggregator> categoryLists = this.getCategoryListMap(facetArrays, partition);
        IntsRef ordinals = new IntsRef(32);
        block0: for (Map.Entry<CategoryListIterator, Aggregator> entry : categoryLists.entrySet()) {
            ScoredDocIDsIterator iterator = docids.iterator();
            CategoryListIterator categoryListIter = entry.getKey();
            Aggregator aggregator = entry.getValue();
            Iterator contexts = this.indexReader.leaves().iterator();
            AtomicReaderContext current = null;
            int maxDoc = -1;
            while (iterator.next()) {
                int docID = iterator.getDocID();
                if (docID >= maxDoc) {
                    boolean iteratorDone = false;
                    do {
                        if (!contexts.hasNext()) {
                            throw new RuntimeException("ScoredDocIDs contains documents outside this reader's segments !?");
                        }
                        current = (AtomicReaderContext)contexts.next();
                        maxDoc = current.docBase + current.reader().maxDoc();
                        if (docID >= maxDoc) continue;
                        boolean validSegment = categoryListIter.setNextReader(current);
                        if (validSegment &= aggregator.setNextReader(current)) continue;
                        while (docID < maxDoc && iterator.next()) {
                            docID = iterator.getDocID();
                        }
                        if (docID >= maxDoc) continue;
                        iteratorDone = true;
                    } while (docID >= maxDoc);
                    if (iteratorDone) continue block0;
                }
                categoryListIter.getOrdinals(docID -= current.docBase, ordinals);
                if (ordinals.length == 0) continue;
                aggregator.aggregate(docID, iterator.getScore(), ordinals);
            }
        }
    }

    private final void initArraysByTotalCounts(FacetArrays facetArrays, int partition, int nAccumulatedDocs) {
        int[] intArray = facetArrays.getIntArray();
        this.totalFacetCounts.fillTotalCountsForPartition(intArray, partition);
        double totalCountsFactor = this.getTotalCountsFactor();
        if (totalCountsFactor < 0.99999) {
            int delta = nAccumulatedDocs + 1;
            int i = 0;
            while (i < intArray.length) {
                int n = i;
                intArray[n] = (int)((double)intArray[n] * totalCountsFactor);
                int n2 = i++;
                intArray[n2] = intArray[n2] + delta;
            }
        }
    }

    protected double getTotalCountsFactor() {
        return 1.0;
    }

    protected HashMap<CategoryListIterator, Aggregator> getCategoryListMap(FacetArrays facetArrays, int partition) throws IOException {
        HashMap<CategoryListIterator, Aggregator> categoryLists = new HashMap<CategoryListIterator, Aggregator>();
        FacetIndexingParams indexingParams = this.searchParams.indexingParams;
        for (FacetRequest facetRequest : this.searchParams.facetRequests) {
            Aggregator categoryAggregator = facetRequest.createAggregator(this.isUsingComplements, facetArrays, this.taxonomyReader);
            CategoryListIterator cli = indexingParams.getCategoryListParams(facetRequest.categoryPath).createCategoryListIterator(partition);
            Aggregator old = categoryLists.put(cli, categoryAggregator);
            if (old == null || old.equals(categoryAggregator)) continue;
            throw new RuntimeException("Overriding existing category list with different aggregator");
        }
        return categoryLists;
    }

    @Override
    public List<FacetResult> accumulate(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        return this.accumulate(new MatchingDocsAsScoredDocIDs(matchingDocs));
    }

    public double getComplementThreshold() {
        return this.complementThreshold;
    }

    public void setComplementThreshold(double complementThreshold) {
        this.complementThreshold = complementThreshold;
    }

    public boolean isUsingComplements() {
        return this.isUsingComplements;
    }
}

