/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.internals.KTableKTableJoinMerger;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.processor.internals.ProcessorAdapter;
import org.apache.kafka.streams.state.StoreBuilder;

public class ProcessorParameters<KIn, VIn, KOut, VOut> {
    private final org.apache.kafka.streams.processor.ProcessorSupplier<KIn, VIn> oldProcessorSupplier;
    private final ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier;
    private final FixedKeyProcessorSupplier<KIn, VIn, VOut> fixedKeyProcessorSupplier;
    private final String processorName;

    public ProcessorParameters(org.apache.kafka.streams.processor.ProcessorSupplier<KIn, VIn> processorSupplier, String processorName) {
        this.oldProcessorSupplier = processorSupplier;
        this.processorSupplier = () -> ProcessorAdapter.adapt(processorSupplier.get());
        this.fixedKeyProcessorSupplier = null;
        this.processorName = processorName;
    }

    public ProcessorParameters(ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier, String processorName) {
        this.oldProcessorSupplier = null;
        this.processorSupplier = processorSupplier;
        this.fixedKeyProcessorSupplier = null;
        this.processorName = processorName;
    }

    public ProcessorParameters(FixedKeyProcessorSupplier<KIn, VIn, VOut> processorSupplier, String processorName) {
        this.oldProcessorSupplier = null;
        this.processorSupplier = null;
        this.fixedKeyProcessorSupplier = processorSupplier;
        this.processorName = processorName;
    }

    public ProcessorSupplier<KIn, VIn, KOut, VOut> processorSupplier() {
        return this.processorSupplier;
    }

    public FixedKeyProcessorSupplier<KIn, VIn, VOut> fixedKeyProcessorSupplier() {
        return this.fixedKeyProcessorSupplier;
    }

    public void addProcessorTo(InternalTopologyBuilder topologyBuilder, String[] parentNodeNames) {
        if (this.processorSupplier != null) {
            topologyBuilder.addProcessor(this.processorName, this.processorSupplier, parentNodeNames);
            if (this.processorSupplier.stores() != null) {
                for (StoreBuilder<?> storeBuilder : this.processorSupplier.stores()) {
                    topologyBuilder.addStateStore(storeBuilder, this.processorName);
                }
            }
        }
        if (this.fixedKeyProcessorSupplier != null) {
            topologyBuilder.addProcessor(this.processorName, this.fixedKeyProcessorSupplier, parentNodeNames);
            if (this.fixedKeyProcessorSupplier.stores() != null) {
                for (StoreBuilder<?> storeBuilder : this.fixedKeyProcessorSupplier.stores()) {
                    topologyBuilder.addStateStore(storeBuilder, this.processorName);
                }
            }
        }
        if (this.oldProcessorSupplier != null && this.oldProcessorSupplier.stores() != null) {
            for (StoreBuilder<?> storeBuilder : this.oldProcessorSupplier.stores()) {
                topologyBuilder.addStateStore(storeBuilder, this.processorName);
            }
        }
    }

    KTableSource<KIn, VIn> kTableSourceSupplier() {
        return this.processorSupplier instanceof KTableSource ? (KTableSource)this.processorSupplier : null;
    }

    <KR, VR> KTableProcessorSupplier<KIn, VIn, KR, VR> kTableProcessorSupplier() {
        return this.processorSupplier instanceof KTableProcessorSupplier ? (KTableProcessorSupplier)this.processorSupplier : null;
    }

    KTableKTableJoinMerger<KIn, VIn> kTableKTableJoinMergerProcessorSupplier() {
        return this.processorSupplier instanceof KTableKTableJoinMerger ? (KTableKTableJoinMerger)this.processorSupplier : null;
    }

    public String processorName() {
        return this.processorName;
    }

    public String toString() {
        return "ProcessorParameters{processor supplier class=" + (this.processorSupplier != null ? this.processorSupplier.getClass() : "null") + ", fixed key processor supplier class=" + (this.fixedKeyProcessorSupplier != null ? this.fixedKeyProcessorSupplier.getClass() : "null") + ", processor name='" + this.processorName + '\'' + '}';
    }
}

