/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RequestContextTest {
    @Test
    public void testSerdeUnsupportedApiVersionRequest() throws Exception {
        int correlationId = 23423;
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, Short.MAX_VALUE, "", correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, false);
        Assertions.assertEquals((int)0, (int)context.apiVersion());
        ByteBuffer requestBuffer = ByteBuffer.allocate(8);
        requestBuffer.putInt(3709234);
        requestBuffer.putInt(29034);
        requestBuffer.flip();
        RequestAndSize requestAndSize = context.parseRequest(requestBuffer);
        Assertions.assertTrue((boolean)(requestAndSize.request instanceof ApiVersionsRequest));
        ApiVersionsRequest request = (ApiVersionsRequest)requestAndSize.request;
        Assertions.assertTrue((boolean)request.hasUnsupportedRequestVersion());
        Send send = context.buildResponseSend((AbstractResponse)new ApiVersionsResponse(new ApiVersionsResponseData().setThrottleTimeMs(0).setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setApiKeys(new ApiVersionsResponseData.ApiVersionCollection())));
        ByteBufferChannel channel = new ByteBufferChannel(256L);
        send.writeTo((TransferableChannel)channel);
        ByteBuffer responseBuffer = channel.buffer();
        responseBuffer.flip();
        responseBuffer.getInt();
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(header.apiVersion()));
        Assertions.assertEquals((int)correlationId, (int)responseHeader.correlationId());
        ApiVersionsResponse response = (ApiVersionsResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.API_VERSIONS, (ByteBuffer)responseBuffer, (short)0);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)response.data().errorCode());
        Assertions.assertTrue((boolean)response.data().apiKeys().isEmpty());
    }

    @Test
    public void testEnvelopeResponseSerde() throws Exception {
        CreateTopicsResponseData.CreatableTopicResultCollection collection = new CreateTopicsResponseData.CreatableTopicResultCollection();
        collection.add(new CreateTopicsResponseData.CreatableTopicResult().setTopicConfigErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setNumPartitions(5));
        CreateTopicsResponseData expectedResponse = new CreateTopicsResponseData().setThrottleTimeMs(10).setTopics(collection);
        int correlationId = 15;
        String clientId = "clientId";
        RequestHeader header = new RequestHeader(ApiKeys.CREATE_TOPICS, ApiKeys.CREATE_TOPICS.latestVersion(), clientId, correlationId);
        RequestContext context = new RequestContext(header, "0", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, new ListenerName("ssl"), SecurityProtocol.SASL_SSL, ClientInformation.EMPTY, true);
        ByteBuffer buffer = context.buildResponseEnvelopePayload((AbstractResponse)new CreateTopicsResponse(expectedResponse));
        Assertions.assertEquals((int)buffer.capacity(), (int)buffer.limit(), (String)"Buffer limit and capacity should be the same");
        CreateTopicsResponse parsedResponse = (CreateTopicsResponse)AbstractResponse.parseResponse((ByteBuffer)buffer, (RequestHeader)header);
        Assertions.assertEquals((Object)expectedResponse, (Object)parsedResponse.data());
    }
}

