/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.IOException;
import java.util.Map;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.font.PDCIDFontType0Font;
import org.pdfbox.pdmodel.font.PDCIDFontType2Font;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDMMType1Font;
import org.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.pdfbox.pdmodel.font.PDType0Font;
import org.pdfbox.pdmodel.font.PDType1Font;
import org.pdfbox.pdmodel.font.PDType3Font;

public class PDFontFactory {
    private PDFontFactory() {
    }

    public static PDFont createFont(COSDictionary dic, Map fontCache) throws IOException {
        PDFont font = null;
        if (fontCache != null) {
            font = (PDFont)fontCache.get(dic);
        }
        if (font == null) {
            font = PDFontFactory.createFont(dic);
            if (fontCache != null) {
                fontCache.put(dic, font);
            }
        }
        return font;
    }

    public static PDFont createFont(COSDictionary dic) throws IOException {
        PDFont retval = null;
        COSName type = (COSName)dic.getDictionaryObject(COSName.TYPE);
        if (!type.equals(COSName.FONT)) {
            throw new IOException("Cannot create font if /Type is not /Font.  Actual=" + type);
        }
        COSName subType = (COSName)dic.getDictionaryObject(COSName.SUBTYPE);
        if (subType.equals(COSName.getPDFName("Type1"))) {
            retval = new PDType1Font(dic);
        } else if (subType.equals(COSName.getPDFName("MMType1"))) {
            retval = new PDMMType1Font(dic);
        } else if (subType.equals(COSName.getPDFName("TrueType"))) {
            retval = new PDTrueTypeFont(dic);
        } else if (subType.equals(COSName.getPDFName("Type3"))) {
            retval = new PDType3Font(dic);
        } else if (subType.equals(COSName.getPDFName("Type0"))) {
            retval = new PDType0Font(dic);
        } else if (subType.equals(COSName.getPDFName("CIDFontType0"))) {
            retval = new PDCIDFontType0Font(dic);
        } else if (subType.equals(COSName.getPDFName("CIDFontType2"))) {
            retval = new PDCIDFontType2Font(dic);
        } else {
            throw new IOException("Unknown font subtype=" + subType);
        }
        return retval;
    }
}

